/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.event;

import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemFoxScroll;
import com.github.tartaricacid.touhoulittlemaid.item.ItemServantBell;
import com.github.tartaricacid.touhoulittlemaid.util.RenderHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.apache.commons.lang3.tuple.Pair;

@Environment(value=EnvType.CLIENT)
public class ScrollRenderEvent {
    public static void onRenderWorldLastEvent(WorldRenderContext context) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player != null) {
            Optional<Pair<String, class_2338>> trackInfo = ScrollRenderEvent.getInfo((class_1657)player, player.method_6047());
            if (trackInfo.isEmpty()) {
                return;
            }
            Pair<String, class_2338> info = trackInfo.get();
            String dimension = (String)info.getLeft();
            class_243 trackVec = new class_243((double)((class_2338)info.getRight()).method_10263(), (double)((class_2338)info.getRight()).method_10264(), (double)((class_2338)info.getRight()).method_10260());
            if (!dimension.equals(player.field_6002.method_27983().method_29177().toString())) {
                return;
            }
            class_243 playerVec = player.method_19538();
            double actualDistance = playerVec.method_1022(trackVec);
            if (actualDistance < 5.0) {
                return;
            }
            double viewDistance = actualDistance;
            double maxRenderDistance = (Integer)mc.field_1690.method_42503().method_41753() * 16;
            if (actualDistance > maxRenderDistance) {
                class_243 delta = trackVec.method_1020(playerVec).method_1029();
                trackVec = playerVec.method_1031(delta.field_1352 * maxRenderDistance, delta.field_1351 * maxRenderDistance, delta.field_1350 * maxRenderDistance);
                viewDistance = maxRenderDistance;
            }
            float scale = 0.02f * (((float)viewDistance + 4.0f) / 3.0f);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderHelper.renderFloatingText(context.matrixStack(), Math.round(actualDistance) + " m", trackVec, 0xFF8800, scale, -17.0f);
            RenderHelper.renderFloatingText(context.matrixStack(), "\u25bc", trackVec, 0xFF0000, scale * 1.2f, -5.0f);
        }
    }

    private static Optional<Pair<String, class_2338>> getInfo(class_1657 player, class_1799 stack) {
        if (stack.method_7909() instanceof ItemFoxScroll) {
            Pair<String, class_2338> trackInfo = ItemFoxScroll.getTrackInfo(player.method_6047());
            return Optional.ofNullable(trackInfo);
        }
        if (stack.method_31574(InitItems.SERVANT_BELL)) {
            Pair<String, class_2338> maidShow = ItemServantBell.getMaidShow(stack);
            return Optional.ofNullable(maidShow);
        }
        return Optional.empty();
    }
}

