/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.client.init;

import com.github.tartaricacid.touhoulittlemaid.client.renderer.item.PerspectiveBakedModel;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.item.ReplaceableBakedModel;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.VanillaConfig;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.minecraft.class_1087;
import net.minecraft.class_1091;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

@Environment(value=EnvType.CLIENT)
public final class InitSpecialItemRender
implements ModelLoadingPlugin {
    private static final List<Pair<class_1091, class_2960>> PERSPECTIVE_MODEL_LIST = Lists.newArrayList();
    private static final List<Triple<class_1091, class_2960, Supplier<Boolean>>> REPLACEABLE_MODEL_LIST = Lists.newArrayList();
    private static final class_2960 LIFE_POINT = new class_2960("touhou_little_maid", "life_point");
    private static final class_2960 POINT_ITEM = new class_2960("touhou_little_maid", "point_item");
    private static final class_2960 SPAWN_BOX = new class_2960("touhou_little_maid", "item/spawn_box");
    private static final class_2960 REBORN_MAID = new class_2960("touhou_little_maid", "item/reborn_maid");
    private static final class_2960 SPAWN_LIGHTNING_BOLT = new class_2960("touhou_little_maid", "item/spawn_lightning_bolt");

    public void onInitializeModelLoader(ModelLoadingPlugin.Context plugin) {
        InitSpecialItemRender.register();
        InitSpecialItemRender.registerModels(plugin);
        plugin.modifyModelAfterBake().register((bakedModel, context) -> {
            class_1087 newModel;
            class_1091 modelId;
            if (bakedModel == null) {
                return bakedModel;
            }
            class_2960 id = context.id();
            for (Pair<class_1091, class_2960> pair : PERSPECTIVE_MODEL_LIST) {
                if (!(id instanceof class_1091) || !(modelId = (class_1091)id).equals(pair.getLeft()) || (newModel = context.baker().method_45873((class_2960)pair.getRight(), context.settings())) == null) continue;
                return new PerspectiveBakedModel(bakedModel, newModel);
            }
            for (Triple triple : REPLACEABLE_MODEL_LIST) {
                if (!(id instanceof class_1091) || !(modelId = (class_1091)id).equals(triple.getLeft()) || (newModel = context.baker().method_45873((class_2960)triple.getMiddle(), context.settings())) == null) continue;
                return new ReplaceableBakedModel(bakedModel, newModel, (Supplier)triple.getRight());
            }
            return bakedModel;
        });
    }

    public static void register() {
        InitSpecialItemRender.addInHandModel(InitItems.HAKUREI_GOHEI);
        InitSpecialItemRender.addInHandModel(InitItems.SANAE_GOHEI);
        InitSpecialItemRender.addInHandModel(InitItems.EXTINGUISHER);
        InitSpecialItemRender.addInHandModel(InitItems.CAMERA);
        InitSpecialItemRender.addInHandModel(InitItems.MAID_BEACON);
        InitSpecialItemRender.addReplaceableModel(class_1802.field_8288, LIFE_POINT, () -> (Boolean)VanillaConfig.REPLACE_TOTEM_TEXTURE.get());
        InitSpecialItemRender.addReplaceableModel(class_1802.field_8287, POINT_ITEM, () -> (Boolean)VanillaConfig.REPLACE_XP_BOTTLE_TEXTURE.get());
    }

    public static void registerModels(ModelLoadingPlugin.Context plugin) {
        plugin.addModels(PERSPECTIVE_MODEL_LIST.stream().map(Pair::getRight).toList());
        plugin.addModels(REPLACEABLE_MODEL_LIST.stream().map(Triple::getMiddle).toList());
        plugin.addModels(new class_2960[]{SPAWN_BOX});
        plugin.addModels(new class_2960[]{REBORN_MAID});
        plugin.addModels(new class_2960[]{SPAWN_LIGHTNING_BOLT});
    }

    public static void addInHandModel(class_1792 item) {
        class_2960 res = class_7923.field_41178.method_10221((Object)item);
        if (res != null) {
            class_1091 rawName = new class_1091(res, "inventory");
            class_2960 inHandName = new class_2960(res.method_12836(), "item/" + res.method_12832() + "_in_hand");
            PERSPECTIVE_MODEL_LIST.add((Pair<class_1091, class_2960>)Pair.of((Object)rawName, (Object)inHandName));
        }
    }

    public static void addReplaceableModel(class_1792 item, class_2960 replacedModel, Supplier<Boolean> isReplace) {
        class_2960 res = class_7923.field_41178.method_10221((Object)item);
        if (res != null) {
            class_1091 rawModelResourceLocation = new class_1091(res, "inventory");
            class_2960 replacedModelResourceLocation = new class_2960(replacedModel.method_12836(), "item/" + replacedModel.method_12832());
            REPLACEABLE_MODEL_LIST.add((Triple<class_1091, class_2960, Supplier<Boolean>>)Triple.of((Object)rawModelResourceLocation, (Object)replacedModelResourceLocation, isReplace));
        }
    }
}

