/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.binding.PrimaryBinding;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.value.DoubleValue;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.value.IValue;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.value.MolangValue;
import com.github.tartaricacid.touhoulittlemaid.molang.MolangEngine;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ParseException;
import com.github.tartaricacid.touhoulittlemaid.molang.runtime.binding.ObjectBinding;
import java.util.Map;

public class MolangParser {
    private final MolangEngine engine;
    private final PrimaryBinding primaryBinding;

    public MolangParser(Map<String, ObjectBinding> extraBindings) {
        this.primaryBinding = new PrimaryBinding(extraBindings);
        this.engine = MolangEngine.fromCustomBinding(this.primaryBinding);
    }

    public IValue parseExpression(String molangExpression) {
        try {
            return this.parseExpressionUnsafe(molangExpression);
        }
        catch (Exception e) {
            TouhouLittleMaid.LOGGER.error("Failed to parse value \"{}\": {}", (Object)molangExpression, (Object)e.getMessage());
            return DoubleValue.ZERO;
        }
    }

    public IValue parseExpressionUnsafe(String molangExpression) throws ParseException {
        MolangValue value = new MolangValue(this.engine.parse(molangExpression));
        this.primaryBinding.popStackFrame();
        return value;
    }

    public IValue getConstant(double value) {
        return new DoubleValue(value);
    }

    public void reset() {
        this.primaryBinding.reset();
    }
}

