/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.molang.parser.ast;

import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.Expression;
import com.github.tartaricacid.touhoulittlemaid.molang.parser.ast.ExpressionVisitor;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class StringExpression
implements Expression {
    private final String value;

    public StringExpression(@NotNull String value) {
        this.value = Objects.requireNonNull(value, "value");
    }

    @NotNull
    public String value() {
        return this.value;
    }

    @Override
    public <R> R visit(@NotNull ExpressionVisitor<R> visitor) {
        return visitor.visitString(this);
    }

    public String toString() {
        return "String('" + this.value + "')";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringExpression that = (StringExpression)o;
        return this.value.equals(that.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

