/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import cn.sh1rocu.touhoulittlemaid.api.extension.IBlockEntityPersistentData;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class TileEntityMaidBeacon
extends class_2586
implements IBlockEntityPersistentData {
    public static final class_2591<TileEntityMaidBeacon> TYPE = class_2591.class_2592.method_20528(TileEntityMaidBeacon::new, (class_2248[])new class_2248[]{InitBlocks.MAID_BEACON}).method_11034(null);
    public static final String POTION_INDEX_TAG = "PotionIndex";
    public static final String STORAGE_POWER_TAG = "StoragePower";
    public static final String OVERFLOW_DELETE_TAG = "OverflowDelete";
    private int potionIndex = -1;
    private float storagePower;
    private boolean overflowDelete = false;

    public TileEntityMaidBeacon(class_2338 blockPos, class_2680 blockState) {
        super(TYPE, blockPos, blockState);
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, TileEntityMaidBeacon beacon) {
        if (beacon.field_11863 != null && !level.field_9236 && level.method_8510() % 80L == 0L) {
            if (beacon.potionIndex != -1 && beacon.storagePower >= beacon.getEffectCost()) {
                beacon.storagePower -= beacon.getEffectCost();
                beacon.updateBeaconEffect(level, BeaconEffect.getEffectByIndex(beacon.potionIndex).getEffect());
            }
            beacon.updateAbsorbPower(level);
        }
    }

    private void updateBeaconEffect(class_1937 world, class_1291 potion) {
        List list = world.method_8390(EntityMaid.class, new class_238(this.method_11016()).method_1009(8.0, 8.0, 8.0), class_1309::method_5805);
        for (EntityMaid maid : list) {
            maid.method_6092(new class_1293(potion, 100, 1, true, true));
        }
    }

    private void updateAbsorbPower(class_1937 world) {
        int range = (Integer)MiscConfig.SHRINE_LAMP_MAX_RANGE.get();
        List list = world.method_8390(EntityPowerPoint.class, new class_238(this.method_11016()).method_1009((double)range, (double)range, (double)range), class_1297::method_5805);
        for (EntityPowerPoint powerPoint : list) {
            float addNum = this.getStoragePower() + (float)powerPoint.value / 100.0f;
            if (addNum <= this.getMaxStorage()) {
                this.setStoragePower(addNum);
                powerPoint.spawnExplosionParticle();
                powerPoint.method_31472();
                continue;
            }
            if (!this.overflowDelete) continue;
            powerPoint.spawnExplosionParticle();
            powerPoint.method_31472();
        }
    }

    public void method_11007(class_2487 compound) {
        this.getPersistentData().method_10569(POTION_INDEX_TAG, this.potionIndex);
        this.getPersistentData().method_10548(STORAGE_POWER_TAG, this.storagePower);
        this.getPersistentData().method_10556(OVERFLOW_DELETE_TAG, this.overflowDelete);
        super.method_11007(compound);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        this.potionIndex = this.getPersistentData().method_10550(POTION_INDEX_TAG);
        this.storagePower = this.getPersistentData().method_10583(STORAGE_POWER_TAG);
        this.overflowDelete = this.getPersistentData().method_10577(OVERFLOW_DELETE_TAG);
    }

    public void loadData(class_2487 data) {
        this.potionIndex = data.method_10550(POTION_INDEX_TAG);
        this.storagePower = data.method_10583(STORAGE_POWER_TAG);
        this.overflowDelete = data.method_10577(OVERFLOW_DELETE_TAG);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public int getPotionIndex() {
        return this.potionIndex;
    }

    public void setPotionIndex(int potionIndex) {
        this.potionIndex = potionIndex;
        this.refresh();
    }

    public float getStoragePower() {
        return this.storagePower;
    }

    public void setStoragePower(float storagePower) {
        this.storagePower = storagePower;
        this.refresh();
    }

    public boolean isOverflowDelete() {
        return this.overflowDelete;
    }

    public void setOverflowDelete(boolean overflowDelete) {
        this.overflowDelete = overflowDelete;
        this.refresh();
    }

    public float getEffectCost() {
        return (float)((Double)MiscConfig.SHRINE_LAMP_EFFECT_COST.get() / 900.0);
    }

    public float getMaxStorage() {
        return ((Double)MiscConfig.SHRINE_LAMP_MAX_STORAGE.get()).floatValue();
    }

    public void refresh() {
        this.method_5431();
        if (this.field_11863 != null) {
            class_2680 state = this.field_11863.method_8320(this.field_11867);
            this.field_11863.method_8413(this.field_11867, state, state, 3);
        }
    }

    public static enum BeaconEffect {
        SPEED(class_1294.field_5904),
        FIRE_RESISTANCE(class_1294.field_5918),
        STRENGTH(class_1294.field_5910),
        RESISTANCE(class_1294.field_5907),
        REGENERATION(class_1294.field_5924);

        private final class_1291 effect;

        private BeaconEffect(class_1291 effect) {
            this.effect = effect;
        }

        public static BeaconEffect getEffectByIndex(int index) {
            return BeaconEffect.values()[class_3532.method_15340((int)0, (int)index, (int)(BeaconEffect.values().length - 1))];
        }

        public class_1291 getEffect() {
            return this.effect;
        }
    }
}

