/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation.ICachedEvaluator;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.CenterOffsetBlockPosSet;
import com.google.common.collect.Lists;
import java.util.Optional;
import java.util.Queue;
import java.util.function.Predicate;
import net.minecraft.class_1308;
import net.minecraft.class_1937;
import net.minecraft.class_1950;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_8;
import net.minecraft.class_9;
import org.jetbrains.annotations.Nullable;

public class MaidPathFindingBFS {
    private final class_9[] tmpNode = new class_9[20];
    private final CenterOffsetBlockPosSet cachePos;
    private final Queue<class_9> queueNode = Lists.newLinkedList();
    private final class_8 nodeEvaluator;
    private final class_2338 centerPos;
    private final double maxDistance;
    private final int verticalSearchRange;
    private boolean isFinished = false;

    public MaidPathFindingBFS(class_8 nodeEvaluator, class_3218 level, EntityMaid maid) {
        this(nodeEvaluator, level, maid, maid.searchRadius(), 7);
    }

    public MaidPathFindingBFS(class_8 nodeEvaluator, class_3218 level, EntityMaid maid, int verticalSearchRange) {
        this(nodeEvaluator, level, maid, maid.searchRadius(), verticalSearchRange);
    }

    public MaidPathFindingBFS(class_8 nodeEvaluator, class_3218 level, EntityMaid maid, float maxDistance, int verticalSearchRange) {
        this.nodeEvaluator = nodeEvaluator;
        this.centerPos = maid.method_24515();
        this.maxDistance = maxDistance;
        this.verticalSearchRange = verticalSearchRange;
        int offset = (int)Math.ceil(this.maxDistance);
        class_1950 region = new class_1950((class_1937)level, this.centerPos.method_10069(-offset, -verticalSearchRange, -offset), this.centerPos.method_10069(offset, verticalSearchRange, offset));
        this.cachePos = new CenterOffsetBlockPosSet(offset + 1, verticalSearchRange + 1, offset + 1, this.centerPos.method_10263(), this.centerPos.method_10264(), this.centerPos.method_10260());
        if (nodeEvaluator instanceof ICachedEvaluator) {
            ICachedEvaluator ice = (ICachedEvaluator)nodeEvaluator;
            ice.init(offset, verticalSearchRange, offset, this.centerPos.method_10263(), this.centerPos.method_10264(), this.centerPos.method_10260());
        }
        nodeEvaluator.method_12(region, (class_1308)maid);
        class_9 start = nodeEvaluator.method_21();
        if (start != null) {
            this.cachePos.markVis(start.method_22879());
            this.queueNode.add(start);
        }
    }

    private boolean canPathReachInternal(class_2338 pos) {
        return this.cachePos.isVis(pos) || this.cachePos.isVis(pos.method_10084());
    }

    public boolean canPathReach(class_2338 pos) {
        if (this.canPathReachInternal(pos)) {
            return true;
        }
        if (this.isFinished) {
            return false;
        }
        while (!this.canPathReachInternal(pos) && !this.isFinished) {
            this.searchStep();
        }
        return this.canPathReachInternal(pos);
    }

    @Nullable
    private class_2338 searchStep() {
        if (this.isFinished) {
            return null;
        }
        if (this.queueNode.isEmpty()) {
            this.isFinished = true;
            return null;
        }
        class_9 node = this.queueNode.poll();
        int neighbors = this.nodeEvaluator.method_18(this.tmpNode, node);
        for (int i = 0; i < neighbors; ++i) {
            double neighborDistance;
            class_2338 offset;
            if (this.cachePos.isVis(this.tmpNode[i].method_22879()) || this.verticalSearchRange < (offset = this.tmpNode[i].method_22879().method_10059((class_2382)this.centerPos)).method_10264() || offset.method_10264() < -this.verticalSearchRange || (neighborDistance = (double)(offset.method_10263() * offset.method_10263() + offset.method_10260() * offset.method_10260())) > this.maxDistance * this.maxDistance) continue;
            this.cachePos.markVis(this.tmpNode[i].method_22879());
            class_8 class_82 = this.nodeEvaluator;
            if (class_82 instanceof ICachedEvaluator) {
                ICachedEvaluator ice = (ICachedEvaluator)class_82;
                ice.markVis(this.tmpNode[i].method_22879());
            }
            this.queueNode.add(this.tmpNode[i]);
        }
        return node.method_22879();
    }

    public Optional<class_2338> find(Predicate<class_2338> predicate) {
        while (!this.isFinished) {
            class_2338 blockPos = this.searchStep();
            if (blockPos == null || !predicate.test(blockPos)) continue;
            return Optional.of(blockPos);
        }
        return Optional.empty();
    }

    public void finish() {
        this.isFinished = true;
        this.nodeEvaluator.method_19();
    }
}

