/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import cn.sh1rocu.touhoulittlemaid.api.extension.IBlockEntityPersistentData;
import com.github.tartaricacid.touhoulittlemaid.api.block.IBoardGameEntityBlock;
import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Position;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityJoy;
import com.github.tartaricacid.touhoulittlemaid.util.WChessUtil;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_7225;

public class TileEntityWChess
extends TileEntityJoy
implements IBoardGameEntityBlock,
IBlockEntityPersistentData {
    public static final class_2591<TileEntityWChess> TYPE = class_2591.class_2592.method_20528(TileEntityWChess::new, (class_2248[])new class_2248[]{InitBlocks.WCHESS}).method_11034(null);
    private static final String CHESS_DATA = "ChessData";
    private static final String CHESS_COUNTER = "ChessCounter";
    private static final String SELECT_CHESS_POINT = "SelectChessPoint";
    private static final String CHECKMATE = "Checkmate";
    private static final String REPEAT = "Repeat";
    private static final String MOVE_NUMBER_LIMIT = "MoveNumberLimit";
    private final Position chessData = new Position();
    private int chessCounter = 0;
    private int selectChessPoint = 0;
    private boolean checkmate = false;
    private boolean repeat = false;
    private boolean moveNumberLimit = false;

    public TileEntityWChess(class_2338 pos, class_2680 blockState) {
        super(TYPE, pos, blockState);
        this.chessData.fromFen("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1");
    }

    @Override
    protected void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        class_2487 data = this.getPersistentData();
        data.method_10582(CHESS_DATA, this.chessData.toFen());
        data.method_10569(CHESS_COUNTER, this.chessCounter);
        data.method_10569(SELECT_CHESS_POINT, this.selectChessPoint);
        data.method_10556(CHECKMATE, this.checkmate);
        data.method_10556(REPEAT, this.repeat);
        data.method_10556(MOVE_NUMBER_LIMIT, this.moveNumberLimit);
        super.method_11007(tag, provider);
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        class_2487 data = this.getPersistentData();
        this.chessCounter = data.method_10550(CHESS_COUNTER);
        this.selectChessPoint = data.method_10550(SELECT_CHESS_POINT);
        this.chessData.fromFen(data.method_10558(CHESS_DATA));
        this.checkmate = data.method_10577(CHECKMATE);
        this.repeat = data.method_10577(REPEAT);
        this.moveNumberLimit = data.method_10577(MOVE_NUMBER_LIMIT);
    }

    public void reset() {
        this.chessCounter = 0;
        this.selectChessPoint = 0;
        this.chessData.fromFen("rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1");
        this.checkmate = false;
        this.repeat = false;
        this.moveNumberLimit = false;
    }

    public Position getChessData() {
        return this.chessData;
    }

    public boolean isCheckmate() {
        return this.checkmate;
    }

    public void setCheckmate(boolean checkmate) {
        this.checkmate = checkmate;
    }

    public boolean isPlayerTurn() {
        return WChessUtil.isPlayer(this.chessData);
    }

    public int getChessCounter() {
        return this.chessCounter;
    }

    public void addChessCounter() {
        ++this.chessCounter;
    }

    public int getSelectChessPoint() {
        return this.selectChessPoint;
    }

    public void setSelectChessPoint(int selectChessPoint) {
        this.selectChessPoint = selectChessPoint;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    public boolean isMoveNumberLimit() {
        return this.moveNumberLimit;
    }

    public void setMoveNumberLimit(boolean moveNumberLimit) {
        this.moveNumberLimit = moveNumberLimit;
    }
}

