/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.block;

import cn.sh1rocu.touhoulittlemaid.api.extension.IBlock;
import com.github.tartaricacid.touhoulittlemaid.api.block.IBoardGameBlock;
import com.github.tartaricacid.touhoulittlemaid.api.game.xqwlight.Position;
import com.github.tartaricacid.touhoulittlemaid.block.BlockJoy;
import com.github.tartaricacid.touhoulittlemaid.block.properties.GomokuPart;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.Type;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntitySit;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.network.message.CChessToClientPackage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityCChess;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityJoy;
import com.github.tartaricacid.touhoulittlemaid.util.CChessUtil;
import com.mojang.serialization.MapCodec;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_702;
import net.minecraft.class_8710;
import net.minecraft.class_9062;
import org.jetbrains.annotations.Nullable;

public class BlockCChess
extends BlockJoy
implements IBoardGameBlock,
IBlock {
    public static final class_2754<GomokuPart> PART = class_2754.method_11850((String)"part", GomokuPart.class);
    public static final class_265 AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public BlockCChess() {
        super(class_4970.class_2251.method_9637().method_31710(class_3620.field_15996).method_9626(class_2498.field_11547).method_9629(2.0f, 3.0f).method_51369().method_22488());
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657(PART, (Comparable)((Object)GomokuPart.CENTER))).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    private static void handleCChessRemove(class_1937 world, class_2338 pos, class_2680 state) {
        if (!world.field_9236) {
            GomokuPart part = (GomokuPart)((Object)state.method_11654(PART));
            class_2338 centerPos = pos.method_10059(new class_2382(part.getPosX(), 0, part.getPosY()));
            class_2586 te = world.method_8321(centerPos);
            BlockCChess.method_9577((class_1937)world, (class_2338)centerPos, (class_1799)InitItems.CCHESS.method_7854());
            if (te instanceof TileEntityCChess) {
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        world.method_8501(centerPos.method_10069(i, 0, j), class_2246.field_10124.method_9564());
                    }
                }
            }
        }
    }

    public static void maidMove(class_3222 player, class_1937 level, class_2338 pos, int move, boolean maidLost, boolean playerLost) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof TileEntityCChess) {
            EntitySit sit;
            class_3218 serverLevel;
            class_1297 class_12972;
            TileEntityCChess chess = (TileEntityCChess)class_25862;
            if (chess.isPlayerTurn()) {
                return;
            }
            Position chessData = chess.getChessData();
            UUID sitId = chess.getSitId();
            if (maidLost && CChessUtil.isMaid(chessData) && chessData.isMate()) {
                EntityMaid maid;
                EntitySit sit2;
                class_3218 serverLevel2;
                class_1297 class_12973;
                chess.setCheckmate(true);
                chess.refresh();
                if (level instanceof class_3218 && (class_12973 = (serverLevel2 = (class_3218)level).method_14190(sitId)) instanceof EntitySit && (class_12973 = (sit2 = (EntitySit)class_12973).method_31483()) instanceof EntityMaid && (maid = (EntityMaid)class_12973).method_6171((class_1309)player)) {
                    maid.getFavorabilityManager().apply(Type.CCHESS_WIN);
                    maid.getGameRecordManager().markStatue(false);
                    InitTrigger.MAID_EVENT.trigger(player, "win_cchess");
                }
                return;
            }
            boolean notChecked = chessData.makeMove(move);
            if (notChecked && chessData.captured()) {
                chessData.setIrrev();
            }
            chess.setSelectChessPoint(Position.DST(move));
            chess.setCheckmate(playerLost);
            if (!playerLost) {
                if (CChessUtil.reachMoveLimit(chessData)) {
                    chess.setMoveNumberLimit(true);
                } else if (CChessUtil.isRepeat(chessData)) {
                    chess.setRepeat(true);
                }
            }
            if (level instanceof class_3218 && (class_12972 = (serverLevel = (class_3218)level).method_14190(sitId)) instanceof EntitySit && (class_12972 = (sit = (EntitySit)class_12972).method_31483()) instanceof EntityMaid) {
                EntityMaid maid = (EntityMaid)class_12972;
                maid.method_6104(class_1268.field_5808);
                if (playerLost) {
                    maid.getGameRecordManager().markStatue(true);
                }
            }
            level.method_8396(null, pos, InitSounds.GOMOKU, class_3419.field_15245, 1.0f, 0.8f + level.field_9229.method_43057() * 0.4f);
            chess.refresh();
        }
    }

    @Override
    public void startMaidSit(EntityMaid maid, class_2680 state, class_1937 worldIn, class_2338 pos) {
        if (worldIn instanceof class_3218) {
            class_3218 serverLevel = (class_3218)worldIn;
            class_2586 class_25862 = worldIn.method_8321(pos);
            if (class_25862 instanceof TileEntityJoy) {
                TileEntityJoy joy = (TileEntityJoy)class_25862;
                class_1297 oldSitEntity = serverLevel.method_14190(joy.getSitId());
                if (oldSitEntity != null && oldSitEntity.method_5805()) {
                    return;
                }
                class_2350 face = ((class_2350)state.method_11654((class_2769)FACING)).method_10153();
                class_243 position = new class_243(0.5 + (double)(face.method_10148() * 2), 0.1, 0.5 + (double)(face.method_10165() * 2));
                EntitySit newSitEntity = new EntitySit(worldIn, class_243.method_49273((class_2382)pos, (double)position.field_1352, (double)position.field_1351, (double)position.field_1350), this.getTypeName(), pos);
                newSitEntity.method_36456(face.method_10153().method_10144() + (float)this.sitYRot());
                worldIn.method_8649((class_1297)newSitEntity);
                joy.setSitId(newSitEntity.method_5667());
                joy.method_5431();
                maid.method_5804(newSitEntity);
            }
        }
    }

    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        BlockCChess.handleCChessRemove(world, pos, state);
        return super.method_9576(world, pos, state, player);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public boolean addHitEffects(class_2680 state, class_1937 world, class_239 target, class_702 manager) {
        return false;
    }

    @Override
    public void onBlockExploded(class_2680 state, class_1937 world, class_2338 pos, class_1927 explosion) {
        BlockCChess.handleCChessRemove(world, pos, state);
        IBlock.super.onBlockExploded(state, world, pos, explosion);
    }

    @Override
    @Nullable
    public class_2680 method_9605(class_1750 context) {
        class_2338 centerPos = context.method_8037();
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                class_2338 searchPos = centerPos.method_10069(i, 0, j);
                if (context.method_8045().method_8320(searchPos).method_26166(context)) continue;
                return null;
            }
        }
        return (class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)context.method_8042().method_10153());
    }

    public void method_9567(class_1937 worldIn, class_2338 pos, class_2680 state, @javax.annotation.Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(worldIn, pos, state, placer, stack);
        if (worldIn.field_9236) {
            return;
        }
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                class_2338 searchPos = pos.method_10069(i, 0, j);
                GomokuPart part = GomokuPart.getPartByPos(i, j);
                if (part == null || part.isCenter()) continue;
                worldIn.method_8652(searchPos, (class_2680)state.method_11657(PART, (Comparable)((Object)part)), 3);
            }
        }
    }

    @Override
    public class_9062 method_55765(class_1799 itemStack, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (hand == class_1268.field_5808 && player.method_6047().method_7960()) {
                int nowClick;
                class_1297 class_12972;
                GomokuPart part = (GomokuPart)((Object)state.method_11654(PART));
                class_2338 centerPos = pos.method_10059(new class_2382(part.getPosX(), 0, part.getPosY()));
                class_2586 te = level.method_8321(centerPos);
                if (!(te instanceof TileEntityCChess)) {
                    return class_9062.field_47733;
                }
                TileEntityCChess chess = (TileEntityCChess)te;
                if (!chess.isPlayerTurn() && !chess.isCheckmate()) {
                    return class_9062.field_47733;
                }
                class_1297 sitEntity = serverLevel.method_14190(chess.getSitId());
                if (sitEntity == null || !sitEntity.method_5805() || !((class_12972 = sitEntity.method_31483()) instanceof EntityMaid)) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.gomoku.no_maid"));
                    return class_9062.field_47733;
                }
                EntityMaid maid = (EntityMaid)class_12972;
                if (((Boolean)MaidConfig.MAID_GOMOKU_OWNER_LIMIT.get()).booleanValue() && !maid.method_6171((class_1309)player)) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.gomoku.not_owner"));
                    return class_9062.field_47733;
                }
                class_2350 facing = (class_2350)state.method_11654((class_2769)FACING);
                class_243 clickPos = hit.method_17784().method_1023((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()).method_1031((double)part.getPosX() - 0.5, 0.0, (double)part.getPosY() - 0.5).method_1024(facing.method_10144() * ((float)Math.PI / 180));
                boolean clickResetArea = CChessUtil.isClickResetArea(clickPos);
                if (clickResetArea) {
                    chess.reset();
                    chess.refresh();
                    level.method_8396(null, centerPos, InitSounds.GOMOKU_RESET, class_3419.field_15245, 1.0f, 1.0f);
                    maid.getGameRecordManager().resetStatue();
                }
                if ((nowClick = CChessUtil.getClickPosition(clickPos)) < 0 || !Position.IN_BOARD(nowClick)) {
                    return class_9062.field_47732;
                }
                if (chess.isCheckmate() && chess.isPlayerTurn()) {
                    return class_9062.field_47733;
                }
                if (chess.isMoveNumberLimit() || chess.isRepeat()) {
                    return class_9062.field_47733;
                }
                Position chessData = chess.getChessData();
                byte[] squares = chessData.squares;
                int preClick = chess.getSelectChessPoint();
                if (preClick < 0 || squares.length <= preClick) {
                    preClick = 0;
                }
                byte prePiece = squares[preClick];
                byte nowPiece = squares[nowClick];
                if (prePiece <= 0 || CChessUtil.isBlack(prePiece)) {
                    if (CChessUtil.isRed(nowPiece)) {
                        chess.setSelectChessPoint(nowClick);
                        chess.refresh();
                        level.method_8396(null, pos, InitSounds.GOMOKU, class_3419.field_15245, 1.0f, 0.8f + level.field_9229.method_43057() * 0.4f);
                    }
                    return class_9062.field_47728;
                }
                if (CChessUtil.isRed(prePiece) && CChessUtil.isRed(nowPiece)) {
                    chess.setSelectChessPoint(nowClick);
                    chess.refresh();
                    level.method_8396(null, pos, InitSounds.GOMOKU, class_3419.field_15245, 1.0f, 0.8f + level.field_9229.method_43057() * 0.4f);
                    return class_9062.field_47728;
                }
                int move = Position.MOVE(preClick, nowClick);
                if (!chessData.legalMove(move)) {
                    return class_9062.field_47733;
                }
                boolean notChecked = chessData.makeMove(move);
                if (notChecked) {
                    if (chessData.captured()) {
                        chessData.setIrrev();
                    }
                    chess.addChessCounter();
                    chess.setSelectChessPoint(nowClick);
                    chess.refresh();
                    level.method_8396(null, pos, InitSounds.GOMOKU, class_3419.field_15245, 1.0f, 0.8f + level.field_9229.method_43057() * 0.4f);
                    if (player instanceof class_3222) {
                        class_3222 serverPlayer = (class_3222)player;
                        ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new CChessToClientPackage(centerPos, chessData.toFen()));
                    }
                    return class_9062.field_47728;
                }
                player.method_43496((class_2561)class_2561.method_43471((String)"message.touhou_little_maid.cchess.check"));
                level.method_8396(null, pos, (class_3414)class_3417.field_14793.comp_349(), class_3419.field_15245, 1.0f, 0.8f + level.field_9229.method_43057() * 0.4f);
                return class_9062.field_47733;
            }
        }
        return class_9062.field_47732;
    }

    @Override
    protected class_243 sitPosition() {
        return class_243.field_1353;
    }

    @Override
    protected String getTypeName() {
        return Type.GOMOKU.getTypeName();
    }

    @Override
    protected int sitYRot() {
        return 0;
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{PART, FACING});
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        if (((GomokuPart)((Object)state.method_11654(PART))).isCenter()) {
            return new TileEntityCChess(pos, state);
        }
        return null;
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return BlockCChess.method_54094(properties -> new BlockCChess());
    }

    public class_265 method_9530(class_2680 pState, class_1922 pLevel, class_2338 pPos, class_3726 pContext) {
        return AABB;
    }
}

