/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.patchouli;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class AltarRecipeComponent
implements IComponentProcessor {
    private static final String RECIPE_ID = "recipe_id";
    private static final String INPUT = "input";
    private static final String POWER_COST = "power_cost";
    private static final String OUTPUT_ITEM = "output_item";
    private static final String OUTPUT_ENTITY = "output_entity";
    private static final String OUTPUT_DESC = "output_desc";
    @Nullable
    private AltarRecipe recipe;

    public void setup(class_1937 level, IVariableProvider variables) {
        class_2960 recipeId = class_2960.method_60654((String)variables.get(RECIPE_ID, (class_7225.class_7874)level.method_30349()).asString());
        List allAltarRecipes = level.method_8433().method_30027(InitRecipes.ALTAR_CRAFTING);
        for (class_8786 recipe : allAltarRecipes) {
            if (!recipe.comp_1932().equals((Object)recipeId)) continue;
            this.recipe = (AltarRecipe)recipe.comp_1933();
            return;
        }
        this.recipe = new AltarRecipe("altar_recipe", class_7710.field_40251, (class_2371<class_1856>)class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[0]), 0.0f, class_1799.field_8037, class_2960.method_60656((String)"item"), "");
        TouhouLittleMaid.LOGGER.error("Altar recipe not found: {}", (Object)recipeId);
    }

    @Nullable
    public IVariable process(class_1937 level, String key) {
        if (key.startsWith(INPUT)) {
            int index = Integer.parseInt(key.substring(INPUT.length())) - 1;
            if (index < 0 || index >= this.recipe.method_8117().size()) {
                return IVariable.from((Object)class_1799.field_8037, (class_7225.class_7874)level.method_30349());
            }
            class_1856 ingredient = (class_1856)this.recipe.method_8117().get(index);
            class_1799[] stacks = ingredient.method_8105();
            if (stacks.length == 0) {
                return IVariable.from((Object)class_1799.field_8037, (class_7225.class_7874)level.method_30349());
            }
            ArrayList stackNames = Lists.newArrayList();
            for (class_1799 stack : stacks) {
                class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
                stackNames.add(itemId.toString());
            }
            return IVariable.wrap((String)StringUtils.join((Iterable)stackNames, (String)","), (class_7225.class_7874)level.method_30349());
        }
        switch (key) {
            case "power_cost": {
                float powerCost = this.recipe.getPower();
                return IVariable.wrap((String)String.format("x%.2f", Float.valueOf(powerCost)), (class_7225.class_7874)level.method_30349());
            }
            case "output_item": {
                if (!this.recipe.isItemCraft()) {
                    return IVariable.from((Object)class_1799.field_8037, (class_7225.class_7874)level.method_30349());
                }
                return IVariable.from((Object)this.recipe.method_8110((class_7225.class_7874)level.method_30349()), (class_7225.class_7874)level.method_30349());
            }
            case "output_desc": {
                return IVariable.wrap((String)class_1074.method_4662((String)this.recipe.getLangKey(), (Object[])new Object[0]), (class_7225.class_7874)level.method_30349());
            }
            case "output_entity": {
                String entityId = this.recipe.getEntityType().toString();
                if ("touhou_little_maid:box".equals(entityId)) {
                    entityId = "touhou_little_maid:maid";
                }
                return IVariable.wrap((String)entityId, (class_7225.class_7874)level.method_30349());
            }
        }
        return null;
    }
}

