/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IAttackTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidFeedAnimalTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.task.DefaultMaidTaskConfigContainer;
import com.github.tartaricacid.touhoulittlemaid.util.ItemsUtil;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3908;
import net.minecraft.class_4140;
import net.minecraft.class_4816;
import net.minecraft.class_4822;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_5134;
import net.minecraft.class_6670;
import net.minecraft.class_7893;
import net.minecraft.class_7894;
import net.minecraft.class_9285;
import net.minecraft.class_9334;

public class TaskFeedAnimal
implements IAttackTask {
    public static final class_2960 UID = class_2960.method_60655((String)"touhou_little_maid", (String)"feed_animal");
    private static final int MAX_STOP_ATTACK_DISTANCE = 8;

    @Override
    public class_2960 getUid() {
        return UID;
    }

    @Override
    public class_1799 getIcon() {
        return class_1802.field_8861.method_7854();
    }

    @Override
    @Nullable
    public class_3414 getAmbientSound(EntityMaid maid) {
        return SoundUtil.environmentSound(maid, InitSounds.MAID_FEED_ANIMAL, 0.5f);
    }

    @Override
    public List<Pair<Integer, class_7893<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        class_7893 supplementedTask = class_4824.method_47120(this::hasAssaultWeapon, this::findFirstValidAttackTarget);
        class_7893 findTargetTask = class_4828.method_47138(target -> !this.hasAssaultWeapon(maid) || this.farAway((class_1309)target, maid));
        class_7893 moveToTargetTask = class_4822.method_47094((float)0.6f);
        class_7894 attackTargetTask = class_4816.method_46987((int)20);
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)((Object)new MaidFeedAnimalTask(0.6f, (int)((Integer)MaidConfig.FEED_ANIMAL_MAX_NUMBER.get())))), Pair.of((Object)6, (Object)supplementedTask), Pair.of((Object)6, (Object)findTargetTask), Pair.of((Object)6, (Object)moveToTargetTask), Pair.of((Object)6, (Object)attackTargetTask)});
    }

    @Override
    private Optional<? extends class_1309> findFirstValidAttackTarget(EntityMaid maid) {
        long animalCount = this.getEntities(maid).method_38980(e -> maid.method_18407(e.method_24515())).filter(class_1297::method_5805).filter(e -> e instanceof class_1429).count();
        if (animalCount < (long)((Integer)MaidConfig.FEED_ANIMAL_MAX_NUMBER.get() - 2)) {
            return Optional.empty();
        }
        return this.getEntities(maid).method_38980(e -> maid.method_18407(e.method_24515())).filter(class_1297::method_5805).filter(e -> e instanceof class_1429).filter(e -> ((class_1429)e).method_5618() == 0).filter(e -> ((class_1429)e).method_6482()).filter(e -> ItemsUtil.isStackIn(maid.getAvailableInv(false), arg_0 -> ((class_1429)((class_1429)e)).method_6481(arg_0))).filter(maid::canPathReach).findFirst();
    }

    @Override
    public boolean canAttack(EntityMaid maid, class_1309 target) {
        return true;
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"can_feed", (Object)Predicates.alwaysTrue()), Pair.of((Object)"assault_weapon", this::hasAssaultWeapon)});
    }

    @Override
    public class_3908 getTaskConfigGuiProvider(EntityMaid maid) {
        final int entityId = maid.method_5628();
        return new class_3908(){

            public class_2561 method_5476() {
                return class_2561.method_43470((String)"Maid Task Config Container");
            }

            public AbstractMaidContainer createMenu(int index, class_1661 playerInventory, class_1657 player) {
                return new DefaultMaidTaskConfigContainer(index, playerInventory, entityId);
            }
        };
    }

    @Override
    public boolean isWeapon(EntityMaid maid, class_1799 stack) {
        class_9285 attributeModifiers = (class_9285)stack.method_57824(class_9334.field_49636);
        return attributeModifiers != null && attributeModifiers.comp_2393().stream().anyMatch(modifier -> modifier.comp_2395().method_55838(class_5134.field_23721));
    }

    private class_6670 getEntities(EntityMaid maid) {
        return maid.method_18868().method_18904(class_4140.field_18442).orElse(class_6670.method_38971());
    }

    private boolean hasAssaultWeapon(EntityMaid maid) {
        class_9285 attributeModifiers = (class_9285)maid.method_6047().method_57824(class_9334.field_49636);
        return attributeModifiers != null && attributeModifiers.comp_2393().stream().anyMatch(modifier -> modifier.comp_2395().method_55838(class_5134.field_23721));
    }

    private boolean farAway(class_1309 target, EntityMaid maid) {
        return maid.method_5739((class_1297)target) > 8.0f;
    }
}

