/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.core.controller;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.AnimatableEntity;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.AnimationState;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.PlayState;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.Animation;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.AnimationBuilder;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.ILoopType;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.controller.AnimationControllerContext;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.InstructionKeyFrameExecutor;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.ParticleKeyFrameEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.SoundKeyframeEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.event.predicate.AnimationEvent;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.AnimationPoint;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.BoneAnimation;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.BoneAnimationQueue;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.KeyFramePoint;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.TransitionPoint;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.bone.BoneKeyFrame;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.keyframe.bone.EasingType;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.context.AnimationContext;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.snapshot.BoneSnapshot;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.snapshot.BoneTopLevelSnapshot;
import com.github.tartaricacid.touhoulittlemaid.molang.runtime.ExpressionEvaluator;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class AnimationController<T extends AnimatableEntity<?>> {
    private final String name;
    private final Object2ReferenceOpenHashMap<String, BoneAnimationQueue> boneAnimationQueues = new Object2ReferenceOpenHashMap();
    private final ReferenceArrayList<BoneAnimationQueue> activeBoneAnimationQueues = new ReferenceArrayList();
    private InstructionKeyFrameExecutor instructionKeyFrameExecutor;
    public double transitionLengthTicks;
    public boolean isJustStarting = false;
    public double tickOffset;
    public double animationSpeed = 1.0;
    public EasingType easingType = EasingType.LINEAR;
    protected final T animatable;
    protected IAnimationPredicate<T> animationPredicate;
    protected AnimationState animationState = AnimationState.STOPPED;
    protected Queue<Pair<ILoopType, Animation>> animationQueue = new LinkedList<Pair<ILoopType, Animation>>();
    protected Animation currentAnimation;
    protected ILoopType currentAnimationLoop;
    protected AnimationBuilder currentAnimationBuilder = new AnimationBuilder();
    public boolean shouldResetTick = false;
    protected boolean justStartedTransition = false;
    protected boolean needsAnimationReload = false;
    private ISoundListener<T> soundListener;
    private IParticleListener<T> particleListener;
    private boolean justStopped = false;

    public AnimationController(T animatable, String name, float transitionLengthTicks, IAnimationPredicate<T> animationPredicate) {
        this.animatable = animatable;
        this.name = name;
        this.transitionLengthTicks = transitionLengthTicks;
        this.animationPredicate = animationPredicate;
        this.tickOffset = 0.0;
    }

    public AnimationController(T animatable, String name, float transitionLengthTicks, EasingType easingtype, IAnimationPredicate<T> animationPredicate) {
        this.animatable = animatable;
        this.name = name;
        this.transitionLengthTicks = transitionLengthTicks;
        this.easingType = easingtype;
        this.animationPredicate = animationPredicate;
        this.tickOffset = 0.0;
    }

    public void setAnimation(AnimationBuilder builder) {
        if (builder == null || builder.getRawAnimationList().isEmpty()) {
            this.animationState = AnimationState.STOPPED;
        } else if (!builder.getRawAnimationList().equals(this.currentAnimationBuilder.getRawAnimationList()) || this.needsAnimationReload) {
            AtomicBoolean encounteredError = new AtomicBoolean(false);
            LinkedList animations = builder.getRawAnimationList().stream().map(rawAnimation -> {
                Animation animation = ((AnimatableEntity)this.animatable).getAnimation(rawAnimation.animationName);
                if (animation == null) {
                    TouhouLittleMaid.LOGGER.warn("Could not load animation: {}. Is it missing?", (Object)rawAnimation.animationName);
                    encounteredError.set(true);
                    return null;
                }
                ILoopType loopType = animation.loop;
                if (rawAnimation.loopType != null) {
                    loopType = rawAnimation.loopType;
                }
                return Pair.of((Object)loopType, (Object)animation);
            }).collect(Collectors.toCollection(LinkedList::new));
            if (encounteredError.get()) {
                return;
            }
            this.animationQueue = animations;
            this.currentAnimationBuilder = builder;
            this.shouldResetTick = true;
            this.animationState = AnimationState.TRANSITIONING;
            this.justStartedTransition = true;
            this.needsAnimationReload = false;
        }
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public Animation getCurrentAnimation() {
        return this.currentAnimation;
    }

    public AnimationState getAnimationState() {
        return this.animationState;
    }

    public List<BoneAnimationQueue> getBoneAnimationQueues() {
        return this.activeBoneAnimationQueues;
    }

    public void registerSoundListener(ISoundListener<T> soundListener) {
        this.soundListener = soundListener;
    }

    public void registerParticleListener(IParticleListener<T> particleListener) {
        this.particleListener = particleListener;
    }

    public void process(double tick, AnimationEvent<T> event, ExpressionEvaluator<AnimationContext<?>> evaluator, List<BoneTopLevelSnapshot> modelRendererList, boolean crashWhenCantFindBone, boolean isRendererDirty, boolean scheduledUpdate) {
        Animation animation;
        AnimationControllerContext context = new AnimationControllerContext();
        if (this.currentAnimation != null && (animation = ((AnimatableEntity)this.animatable).getAnimation(this.currentAnimation.animationName)) != null && this.currentAnimation != animation) {
            this.currentAnimation = animation;
            this.instructionKeyFrameExecutor = new InstructionKeyFrameExecutor(animation.customInstructionKeyframes);
        }
        if (isRendererDirty) {
            this.switchRenderer(modelRendererList);
            if (this.currentAnimation != null) {
                this.switchAnimation();
            }
        }
        double adjustedTick = this.adjustTick(tick);
        if (this.animationState == AnimationState.TRANSITIONING && adjustedTick >= this.transitionLengthTicks) {
            this.shouldResetTick = true;
            this.animationState = AnimationState.RUNNING;
            adjustedTick = this.adjustTick(tick);
        }
        assert (adjustedTick >= 0.0) : "GeckoLib: Tick was less than zero";
        PlayState playState = this.testAnimationPredicate(event);
        if (playState == PlayState.STOP || this.currentAnimation == null && this.animationQueue.isEmpty()) {
            this.animationState = AnimationState.STOPPED;
            this.justStopped = true;
            return;
        }
        boolean resetTick = this.shouldResetTick;
        if (this.justStartedTransition && (this.shouldResetTick || this.justStopped)) {
            this.justStopped = false;
            adjustedTick = this.adjustTick(tick);
        } else if (this.currentAnimation == null && !this.animationQueue.isEmpty()) {
            this.shouldResetTick = true;
            resetTick = true;
            this.animationState = AnimationState.TRANSITIONING;
            this.justStartedTransition = true;
            this.needsAnimationReload = false;
            adjustedTick = this.adjustTick(tick);
        } else if (this.animationState != AnimationState.TRANSITIONING) {
            this.animationState = AnimationState.RUNNING;
        }
        if (this.animationState == AnimationState.TRANSITIONING) {
            if (resetTick || this.isJustStarting) {
                this.justStartedTransition = false;
                Pair<ILoopType, Animation> current = this.animationQueue.poll();
                if (current != null) {
                    this.currentAnimationLoop = (ILoopType)current.getFirst();
                    this.currentAnimation = (Animation)current.getSecond();
                    this.instructionKeyFrameExecutor = new InstructionKeyFrameExecutor(((Animation)current.getSecond()).customInstructionKeyframes);
                    this.resetEventKeyFrames(false, null);
                    this.switchAnimation();
                } else {
                    this.currentAnimation = null;
                    this.instructionKeyFrameExecutor = null;
                }
            }
            if (this.currentAnimation != null) {
                context.setAnimTime(0.0);
                for (BoneAnimationQueue boneAnimationQueue : this.activeBoneAnimationQueues) {
                    List<BoneKeyFrame> scaleKeyFrames;
                    List<BoneKeyFrame> positionKeyFrames;
                    BoneAnimation boneAnimation = boneAnimationQueue.animation;
                    if (boneAnimation == null) continue;
                    BoneSnapshot boneSnapshot = boneAnimationQueue.snapshot();
                    BoneSnapshot initialSnapshot = boneAnimationQueue.topLevelSnapshot.bone.getInitialSnapshot();
                    List<BoneKeyFrame> rotationKeyFrames = boneAnimation.rotationKeyFrames;
                    if (!rotationKeyFrames.isEmpty()) {
                        TransitionPoint point = this.getTransitionPointAtTick(rotationKeyFrames, adjustedTick, new Vector3f(boneSnapshot.rotationValueX - initialSnapshot.rotationValueX, boneSnapshot.rotationValueY - initialSnapshot.rotationValueY, boneSnapshot.rotationValueZ - initialSnapshot.rotationValueZ), context);
                        boneAnimationQueue.rotationQueue().add(point);
                    }
                    if (!(positionKeyFrames = boneAnimation.positionKeyFrames).isEmpty()) {
                        TransitionPoint point = this.getTransitionPointAtTick(positionKeyFrames, adjustedTick, new Vector3f(boneSnapshot.positionOffsetX, boneSnapshot.positionOffsetY, boneSnapshot.positionOffsetZ), context);
                        boneAnimationQueue.positionQueue().add(point);
                    }
                    if ((scaleKeyFrames = boneAnimation.scaleKeyFrames).isEmpty()) continue;
                    TransitionPoint point = this.getTransitionPointAtTick(scaleKeyFrames, adjustedTick, new Vector3f(boneSnapshot.scaleValueX, boneSnapshot.scaleValueY, boneSnapshot.scaleValueZ), context);
                    boneAnimationQueue.scaleQueue().add(point);
                }
            }
        } else if (this.getAnimationState() == AnimationState.RUNNING) {
            this.resetQueues();
            this.processCurrentAnimation(context, evaluator, adjustedTick, tick, crashWhenCantFindBone, scheduledUpdate);
        }
    }

    protected PlayState testAnimationPredicate(AnimationEvent<T> event) {
        return this.animationPredicate.test(event);
    }

    private void processCurrentAnimation(AnimationControllerContext context, ExpressionEvaluator<AnimationContext<?>> evaluator, double tick, double actualTick, boolean crashWhenCantFindBone, boolean scheduledUpdate) {
        assert (this.currentAnimation != null);
        ((AnimationContext)evaluator.entity()).setAnimationControllerContext(context);
        if (tick >= this.currentAnimation.animationLength) {
            context.setAnimTime(this.currentAnimation.animationLength / 20.0);
            if (!this.currentAnimationLoop.isRepeatingAfterEnd()) {
                Pair<ILoopType, Animation> peek = this.animationQueue.peek();
                if (peek == null) {
                    this.animationState = AnimationState.STOPPED;
                    return;
                }
                this.animationState = AnimationState.TRANSITIONING;
                this.shouldResetTick = true;
                this.currentAnimation = (Animation)peek.getSecond();
                this.instructionKeyFrameExecutor = new InstructionKeyFrameExecutor(((Animation)peek.getSecond()).customInstructionKeyframes);
                this.currentAnimationLoop = (ILoopType)peek.getFirst();
            } else {
                this.shouldResetTick = true;
                tick = this.adjustTick(actualTick);
                this.resetEventKeyFrames(true, evaluator);
            }
        }
        context.setAnimTime(tick / 20.0);
        for (BoneAnimationQueue boneAnimationQueue : this.activeBoneAnimationQueues) {
            List<BoneKeyFrame> scaleKeyFrames;
            List<BoneKeyFrame> positionKeyFrames;
            BoneAnimation boneAnimation = boneAnimationQueue.animation;
            List<BoneKeyFrame> rotationKeyFrames = boneAnimation.rotationKeyFrames;
            if (!rotationKeyFrames.isEmpty()) {
                boneAnimationQueue.rotationQueue().add(this.getKeyFramePointAtTick(rotationKeyFrames, tick, context));
            }
            if (!(positionKeyFrames = boneAnimation.positionKeyFrames).isEmpty()) {
                boneAnimationQueue.positionQueue().add(this.getKeyFramePointAtTick(positionKeyFrames, tick, context));
            }
            if ((scaleKeyFrames = boneAnimation.scaleKeyFrames).isEmpty()) continue;
            boneAnimationQueue.scaleQueue().add(this.getKeyFramePointAtTick(scaleKeyFrames, tick, context));
        }
        if (this.instructionKeyFrameExecutor != null && scheduledUpdate) {
            this.instructionKeyFrameExecutor.executeTo(evaluator, tick);
        }
        if (this.transitionLengthTicks == 0.0 && this.shouldResetTick && this.animationState == AnimationState.TRANSITIONING) {
            Pair<ILoopType, Animation> current = this.animationQueue.poll();
            if (current != null) {
                this.currentAnimation = (Animation)current.getSecond();
                this.currentAnimationLoop = (ILoopType)current.getFirst();
                this.instructionKeyFrameExecutor = new InstructionKeyFrameExecutor(((Animation)current.getSecond()).customInstructionKeyframes);
            } else {
                this.currentAnimation = null;
                this.instructionKeyFrameExecutor = null;
            }
        }
    }

    private void switchAnimation() {
        this.activeBoneAnimationQueues.clear();
        for (BoneAnimation animation : this.currentAnimation.boneAnimations) {
            BoneAnimationQueue queue = (BoneAnimationQueue)this.boneAnimationQueues.get((Object)animation.boneName);
            if (queue == null) continue;
            queue.animation = animation;
            queue.updateSnapshot();
            queue.resetQueues();
            this.activeBoneAnimationQueues.add((Object)queue);
        }
    }

    private void switchRenderer(List<BoneTopLevelSnapshot> modelRendererList) {
        this.boneAnimationQueues.clear();
        for (BoneTopLevelSnapshot modelRenderer : modelRendererList) {
            this.boneAnimationQueues.put((Object)modelRenderer.name, (Object)new BoneAnimationQueue(modelRenderer));
        }
        this.activeBoneAnimationQueues.clear();
        this.markNeedsReload();
    }

    private void resetQueues() {
        for (BoneAnimationQueue queue : this.activeBoneAnimationQueues) {
            queue.resetQueues();
        }
    }

    public double adjustTick(double tick) {
        if (this.shouldResetTick) {
            if (this.getAnimationState() == AnimationState.TRANSITIONING) {
                this.tickOffset = tick;
            } else if (this.getAnimationState() == AnimationState.RUNNING) {
                this.tickOffset = tick;
            }
            this.shouldResetTick = false;
            return 0.0;
        }
        return this.animationSpeed * Math.max(tick - this.tickOffset, 0.0);
    }

    private AnimationPoint getKeyFramePointAtTick(List<BoneKeyFrame> frames, double tick, AnimationControllerContext context) {
        for (int i = 0; i < frames.size(); ++i) {
            if (!(frames.get(i).getStartTick() > tick)) continue;
            BoneKeyFrame frame = frames.get(i - 1);
            return new KeyFramePoint(tick - frame.getStartTick(), frame, context);
        }
        BoneKeyFrame frame = frames.get(frames.size() - 1);
        return new KeyFramePoint(tick - frame.getStartTick(), frame, context);
    }

    private TransitionPoint getTransitionPointAtTick(List<BoneKeyFrame> frames, double tick, Vector3f offsetPoint, AnimationControllerContext context) {
        BoneKeyFrame dstFrame = frames.get(0);
        return new TransitionPoint(tick, this.transitionLengthTicks, offsetPoint, dstFrame, context);
    }

    private void resetEventKeyFrames(boolean reachEnd, ExpressionEvaluator<AnimationContext<?>> evaluator) {
        if (this.instructionKeyFrameExecutor != null) {
            if (reachEnd) {
                this.instructionKeyFrameExecutor.executeRemaining(evaluator);
            }
            this.instructionKeyFrameExecutor.reset();
        }
    }

    public void markNeedsReload() {
        this.needsAnimationReload = true;
    }

    public void clearAnimationCache() {
        this.currentAnimationBuilder = new AnimationBuilder();
    }

    public double getAnimationSpeed() {
        return this.animationSpeed;
    }

    public void setAnimationSpeed(double animationSpeed) {
        this.animationSpeed = animationSpeed;
    }

    @FunctionalInterface
    public static interface IAnimationPredicate<P extends AnimatableEntity<?>> {
        public PlayState test(AnimationEvent<P> var1);
    }

    @FunctionalInterface
    public static interface ISoundListener<A extends AnimatableEntity<?>> {
        public void playSound(SoundKeyframeEvent<A> var1);
    }

    @FunctionalInterface
    public static interface IParticleListener<A extends AnimatableEntity<?>> {
        public void summonParticle(ParticleKeyFrameEvent<A> var1);
    }
}

