package cn.sh1rocu.touhoulittlemaid.mixin.client;

import cn.sh1rocu.touhoulittlemaid.api.extension.IBlock;
import cn.sh1rocu.touhoulittlemaid.api.extension.IPickedResult;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_702;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Environment(EnvType.CLIENT)
@Mixin(class_310.class)
public class MinecraftMixin {
    @Shadow
    @Nullable
    public class_638 level;

    @Shadow
    @Nullable
    public class_239 hitResult;

    @WrapWithCondition(
            method = "continueAttack",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/particle/ParticleEngine;crack(Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/Direction;)V"
            )
    )
    private boolean tlm$addHitEffects(class_702 engine, class_2338 pos, class_2350 side) {
        class_2680 state = this.level.method_8320(pos);
        if (state.method_26204() instanceof IBlock block)
            return !block.addHitEffects(state, level, this.hitResult, engine);
        return true;
    }

    @ModifyExpressionValue(
            method = "pickBlock",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/entity/Entity;getPickResult()Lnet/minecraft/world/item/ItemStack;"
            )
    )
    private class_1799 tlm$pickBlock(class_1799 stack) {
        if (stack != null && stack.method_7909() instanceof IPickedResult item)
            return item.getPickedResult(this.hitResult);
        return stack;
    }
}