package cn.sh1rocu.touhoulittlemaid.mixin.client;

import cn.sh1rocu.touhoulittlemaid.api.event.PlaySoundEvent;
import cn.sh1rocu.touhoulittlemaid.api.mixin.ChannelAccessHandleInjection;
import cn.sh1rocu.touhoulittlemaid.util.kilt.SoundConsumerStorage;
import com.github.tartaricacid.touhoulittlemaid.client.sound.data.MaidSoundInstance;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1111;
import net.minecraft.class_1113;
import net.minecraft.class_1140;
import net.minecraft.class_4224;
import net.minecraft.class_4225;
import net.minecraft.class_4235;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Consumer;

// From Kilt https://github.com/KiltMC/Kilt/blob/version/1.21.1/src/main/java/xyz/bluspring/kilt/forgeinjects/client/sounds/SoundEngineInject.java
@Environment(EnvType.CLIENT)
@Mixin(class_1140.class)
public abstract class SoundEngineMixin {
    @WrapOperation(
            method = "play",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/client/resources/sounds/SoundInstance;canPlaySound()Z"
            )
    )
    private boolean tlm$playSoundEvent(class_1113 instance, Operation<Boolean> original, @Local(argsOnly = true) LocalRef<class_1113> refInstance) {
        PlaySoundEvent event = new PlaySoundEvent((class_1140) (Object) this, instance);
        PlaySoundEvent.CALLBACK.invoker().post(event);
        refInstance.set(event.getSound());
        return refInstance.get() != null && original.call(refInstance.get());
    }

    @Inject(method = "play", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/sounds/ChannelAccess$ChannelHandle;execute(Ljava/util/function/Consumer;)V", shift = At.Shift.AFTER))
    private void tlm$prepareChannelInfo(class_1113 soundInstance, CallbackInfo ci, @Local class_4235.class_4236 channelHandle, @Local class_1111 sound) {
        var injection = ((ChannelAccessHandleInjection) channelHandle);

        if (sound.method_4769())
            injection.tlm$setPool(class_4225.class_4105.field_18353);
        else
            injection.tlm$setPool(class_4225.class_4105.field_18352);

        injection.tlm$setSoundInstance(soundInstance);
        injection.tlm$setSoundEngine((class_1140) (Object) this);
    }

    @ModifyArg(method = "method_19757", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/sounds/ChannelAccess$ChannelHandle;execute(Ljava/util/function/Consumer;)V"))
    private static Consumer<class_4224> tlm$storeSourceConsumer(Consumer<class_4224> consumer) {
        SoundConsumerStorage.soundConsumerChannels.add(consumer);
        return consumer;
    }

    // 暂时用不到
/*    @ModifyArg(method = "method_19758", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/sounds/ChannelAccess$ChannelHandle;execute(Ljava/util/function/Consumer;)V"))
    private static Consumer<Channel> kilt$storeStreamConsumer(Consumer<Channel> consumer) {
        SoundConsumerStorage.soundConsumerChannels.add(consumer);
        return consumer;
    }*/
}
