package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.response.ResponseChat;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.Site;
import com.github.tartaricacid.touhoulittlemaid.ai.service.Service;
import com.github.tartaricacid.touhoulittlemaid.ai.service.chat.openai.ChatClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.chat.openai.request.ChatCompletion;
import com.github.tartaricacid.touhoulittlemaid.ai.service.chat.openai.response.ChatCompletionResponse;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSApiType;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSRequest;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleManger;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.TTSAudioToClientPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.TTSSystemAudioToClientPackage;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class MaidAIChatManager extends MaidAIChatData {
    public MaidAIChatManager(EntityMaid maid) {
        super(maid);
    }

    public void chat(String message, String language) {
        if (AIConfig.CHAT_ENABLED.get()) {
            @Nullable Site site = this.getChatSite();
            if (site == null || StringUtils.isBlank(site.getApiKey())) {
                ChatBubbleManger.addInnerChatText(maid, "ai.touhou_little_maid.chat.api_key.empty");
            } else {
                ChatClient chatClient = Service.getChatClient(site);
                ChatCompletion chatCompletion = Service.getChatCompletion(this, language);
                if (chatCompletion != null) {
                    chatCompletion.userChat(message);
                    chatClient.chat(chatCompletion).handle(this::onShowChatSync, this::onChatFailSync);
                    this.addUserHistory(message);
                } else {
                    ChatBubbleManger.addInnerChatText(maid, "ai.touhou_little_maid.chat.no_setting");
                }
            }
        } else {
            ChatBubbleManger.addInnerChatText(maid, "ai.touhou_little_maid.chat.disable");
        }
    }

    @SuppressWarnings("all")
    private void tts(Site site, String chatText, String ttsText) {
        // 调用系统 TTS，那么此时就只需要发送给指定的玩家即可
        if (TTSApiType.SYSTEM.getName().equals(site.getApiType())) {
            onPlaySoundLocal(chatText, ttsText);
        } else {
            TTSClient ttsClient = Service.getTtsClient(site);
            String ttsLang = "en";
            String[] split = this.getTtsLanguage().split("_");
            if (split.length >= 2) {
                ttsLang = split[0];
            }
            TTSRequest ttsRequest = Service.getTtsRequest(site, ttsText, ttsLang, this.getTtsModel());
            ttsClient.request(ttsRequest).handle(data -> onPlaySoundSync(chatText, (byte[]) data),
                    throwable -> onTtsFailSync(chatText, (Throwable) throwable));
        }
    }

    private void onShowChatSync(ChatCompletionResponse result) {
        String rawMessage = result.getFirstChoiceMessage();
        try {
            ResponseChat responseChat = Service.GSON.fromJson(rawMessage, ResponseChat.class);
            if (responseChat == null) {
                TouhouLittleMaid.LOGGER.error("Error in Response Chat: {}", rawMessage);
                onChatFailSync(class_2561.method_43469("ai.touhou_little_maid.chat.format.json_format_error", rawMessage));
                return;
            }
            String chatText = responseChat.getChatText();
            String ttsText = responseChat.getTtsText();
            if (StringUtils.isBlank(chatText) || StringUtils.isBlank(ttsText)) {
                TouhouLittleMaid.LOGGER.error("Error in Response Chat: {}", rawMessage);
                onChatFailSync(class_2561.method_43469("ai.touhou_little_maid.chat.format.text_is_empty", rawMessage));
                return;
            }
            this.addAssistantHistory(rawMessage);
            Site site = this.getTtsSite();
            if (AIConfig.TTS_ENABLED.get() && site != null && StringUtils.isNotBlank(site.getApiKey())) {
                this.tts(site, chatText, ttsText);
            } else {
                ChatBubbleManger.addAiChatTextSync(maid, chatText);
            }
        } catch (Exception e) {
            TouhouLittleMaid.LOGGER.error(e.getMessage());
        }
    }

    private void onChatFailSync(Throwable throwable) {
        if (!(maid.field_6002 instanceof class_3218 serverLevel)) {
            return;
        }
        MinecraftServer server = serverLevel.method_8503();
        server.method_20493(() -> {
            if (maid.method_35057() instanceof class_3222 player) {
                String cause = throwable.getLocalizedMessage();
                player.method_43496(class_2561.method_43471("ai.touhou_little_maid.chat.connect.fail")
                        .method_27693(cause).method_27692(class_124.field_1061));
            }
        });
    }

    private void onChatFailSync(class_2561 message) {
        if (!(maid.field_6002 instanceof class_3218 serverLevel)) {
            return;
        }
        MinecraftServer server = serverLevel.method_8503();
        server.method_20493(() -> {
            if (maid.method_35057() instanceof class_3222 player) {
                player.method_43496(class_2561.method_43471("ai.touhou_little_maid.chat.connect.fail")
                        .method_10852(message).method_27692(class_124.field_1061));
            }
        });
    }

    private void onPlaySoundLocal(String chatText, String ttsText) {
        if (!(maid.field_6002 instanceof class_3218 serverLevel)) {
            return;
        }
        MinecraftServer server = serverLevel.method_8503();
        server.method_20493(() -> {
            if (maid.method_35057() instanceof class_3222 player) {
                ServerPlayNetworking.send(player, new TTSSystemAudioToClientPackage(ttsText));
            }
            ChatBubbleManger.addAiChatText(maid, chatText);
        });
    }

    private void onPlaySoundSync(String chatText, byte[] data) {
        if (!(maid.field_6002 instanceof class_3218 serverLevel)) {
            return;
        }
        MinecraftServer server = serverLevel.method_8503();
        server.method_20493(() -> {
            NetworkHandler.sendToNearby(maid, new TTSAudioToClientPackage(this.maid.method_5628(), data));
            ChatBubbleManger.addAiChatText(maid, chatText);
        });
    }

    private void onTtsFailSync(String chatText, Throwable throwable) {
        if (!(maid.field_6002 instanceof class_3218 serverLevel)) {
            return;
        }
        MinecraftServer server = serverLevel.method_8503();
        server.method_20493(() -> {
            ChatBubbleManger.addAiChatText(maid, chatText);
            if (maid.method_35057() instanceof class_3222 player) {
                String cause = throwable.getLocalizedMessage();
                player.method_43496(class_2561.method_43471("ai.touhou_little_maid.tts.connect.fail")
                        .method_27693(cause).method_27692(class_124.field_1061));
            }
        });
    }
}
