package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import io.netty.buffer.ByteBuf;
import net.minecraft.class_2487;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class MaidAIDataSerializable {
    public static final class_9139<ByteBuf, MaidAIDataSerializable> STREAM_CODEC = new class_9139<>() {
        @Override
        public void encode(ByteBuf buffer, MaidAIDataSerializable message) {
            class_9135.field_48554.encode(buffer, message.chatSiteName);
            class_9135.field_48554.encode(buffer, message.chatModel);
            class_9135.field_48553.encode(buffer, message.chatTemperature);
            class_9135.field_48554.encode(buffer, message.ttsSiteName);
            class_9135.field_48554.encode(buffer, message.ttsModel);
            class_9135.field_48554.encode(buffer, message.ttsLanguage);
            class_9135.field_48554.encode(buffer, message.ownerName);
            class_9135.field_48554.encode(buffer, message.customSetting);
        }

        @Override
        public MaidAIDataSerializable decode(ByteBuf buffer) {
            String chatSiteName = class_9135.field_48554.decode(buffer);
            String chatModel = class_9135.field_48554.decode(buffer);
            double chatTemperature = class_9135.field_48553.decode(buffer);
            String ttsSiteName = class_9135.field_48554.decode(buffer);
            String ttsModel = class_9135.field_48554.decode(buffer);
            String ttsLanguage = class_9135.field_48554.decode(buffer);
            String ownerName = class_9135.field_48554.decode(buffer);
            String customSetting = class_9135.field_48554.decode(buffer);
            return new MaidAIDataSerializable(chatSiteName, chatModel, chatTemperature, ttsSiteName, ttsModel, ttsLanguage, ownerName, customSetting);
        }
    };

    protected String chatSiteName = "";
    protected String chatModel = "";
    protected double chatTemperature = -1;
    protected String ttsSiteName = "";
    protected String ttsModel = "";
    protected String ttsLanguage = "";
    protected String ownerName = "";
    protected String customSetting = "";

    public MaidAIDataSerializable() {
    }

    public MaidAIDataSerializable(String chatSiteName, String chatModel, double chatTemperature, String ttsSiteName,
                                  String ttsModel, String ttsLanguage, String ownerName, String customSetting) {
        this.chatSiteName = chatSiteName;
        this.chatModel = chatModel;
        this.chatTemperature = chatTemperature;
        this.ttsSiteName = ttsSiteName;
        this.ttsModel = ttsModel;
        this.ttsLanguage = ttsLanguage;
        this.ownerName = ownerName;
        this.customSetting = customSetting;
    }

    public void copyFrom(MaidAIDataSerializable data) {
        chatSiteName = data.chatSiteName;
        chatModel = data.chatModel;
        chatTemperature = data.chatTemperature;
        ttsSiteName = data.ttsSiteName;
        ttsModel = data.ttsModel;
        ttsLanguage = data.ttsLanguage;
        ownerName = data.ownerName;
        customSetting = data.customSetting;
    }

    public void readFromTag(class_2487 tag) {
        if (tag.method_10545("MaidAIChatData")) {
            class_2487 data = tag.method_10562("MaidAIChatData");
            chatSiteName = data.method_10558("ChatSiteName");
            chatModel = data.method_10558("ChatModel");
            chatTemperature = data.method_10574("ChatTemperature");
            ttsSiteName = data.method_10558("TtsSiteName");
            ttsModel = data.method_10558("TtsModel");
            ttsLanguage = data.method_10558("TtsLanguage");
            ownerName = data.method_10558("OwnerName");
            customSetting = data.method_10558("CustomSetting");
        }
    }

    public void writeToTag(class_2487 tag) {
        class_2487 data = new class_2487();
        {
            data.method_10582("ChatSiteName", chatSiteName);
            data.method_10582("ChatModel", chatModel);
            data.method_10549("ChatTemperature", chatTemperature);
            data.method_10582("TtsSiteName", ttsSiteName);
            data.method_10582("TtsModel", ttsModel);
            data.method_10582("TtsLanguage", ttsLanguage);
            data.method_10582("OwnerName", ownerName);
            data.method_10582("CustomSetting", customSetting);
        }
        tag.method_10566("MaidAIChatData", data);
    }

    public String getChatSiteName() {
        return chatSiteName;
    }

    public void setChatSiteName(String chatSiteName) {
        this.chatSiteName = chatSiteName;
    }

    public String getChatModel() {
        return chatModel;
    }

    public void setChatModel(String chatModel) {
        this.chatModel = chatModel;
    }

    public double getChatTemperature() {
        return chatTemperature;
    }

    public void setChatTemperature(double chatTemperature) {
        this.chatTemperature = chatTemperature;
    }

    public String getTtsSiteName() {
        return ttsSiteName;
    }

    public void setTtsSiteName(String ttsSiteName) {
        this.ttsSiteName = ttsSiteName;
    }

    public String getTtsModel() {
        return ttsModel;
    }

    public void setTtsModel(String ttsModel) {
        this.ttsModel = ttsModel;
    }

    public String getTtsLanguage() {
        return ttsLanguage;
    }

    public void setTtsLanguage(String ttsLanguage) {
        this.ttsLanguage = ttsLanguage;
    }

    public String getOwnerName() {
        return ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getCustomSetting() {
        return customSetting;
    }

    public void setCustomSetting(String customSetting) {
        this.customSetting = customSetting;
    }
}
