package com.github.tartaricacid.touhoulittlemaid.ai.manager.setting;

import cn.sh1rocu.touhoulittlemaid.util.itemhandler.RangedWrapper;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.response.ResponseChat;
import com.github.tartaricacid.touhoulittlemaid.ai.service.Service;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

// TODO: 有必要支持多语言版本么？现在的大语言模型都自带翻译功能？
public class PapiReplacer {
    static String replace(String input, EntityMaid maid, String language) {
        class_1937 level = maid.field_6002;
        return input.replace("${game_time}", getTime(level))
                .replace("${weather}", getWeather(level))
                .replace("${dimension}", getDimension(level))
                .replace("${mainhand_item}", getSlotItemName(class_1304.field_6173, maid))
                .replace("${offhand_item}", getSlotItemName(class_1304.field_6171, maid))
                .replace("${inventory_items}", getInventoryItems(maid))
                .replace("${output_json_format}", getOutputJsonFormat())
                .replace("${chat_language}", language)
                .replace("${tts_language}", ttsLanguage(maid.getAiChatManager().getTtsLanguage()))
                .replace("${healthy}", getHealthyInfo(maid))
                .replace("${owner_healthy}", getOwnerHealthyInfo(maid))
                .replace("${armor_items}", getArmorItems(maid))
                .replace("${effects}", getEffects(maid))
                .replace("${biome}", getBiome(maid))
                .replace("${owner_name}", getOwnerName(maid))
                .replace("${custom_setting}", maid.getAiChatManager().getCustomSetting());
    }

    /**
     * 不能调用 LanguageManager，那个是客户端方法
     */
    private static String ttsLanguage(String languageTag) {
        // 将语言代码转换为 Locale 所需的格式，例如 zh_cn -> zh-CN
        String[] parts = languageTag.split("_");
        if (parts.length == 2) {
            languageTag = parts[0] + "-" + parts[1].toUpperCase(Locale.ENGLISH);
        }
        Locale locale = Locale.forLanguageTag(languageTag);
        return locale.getDisplayLanguage() + " (" + locale.getDisplayCountry() + ")";
    }

    private static String getBiome(EntityMaid maid) {
        class_1959 biome = maid.field_6002.method_23753(maid.method_24515()).comp_349();
        class_2960 key = maid.field_6002.method_30349().method_30530(class_7924.field_41236).method_10221(biome);
        return key == null ? "未知 Biome" : key.toString();
    }

    private static String getEffects(EntityMaid maid) {
        List<String> names = new ArrayList<>();
        maid.method_6026().forEach(i -> {
            names.add(i.toString());
        });
        if (names.isEmpty()) {
            return "无";
        }
        return StringUtils.join(names, ", ");
    }

    private static String getArmorItems(EntityMaid maid) {
        List<String> names = new ArrayList<>();
        maid.method_5661().forEach(stack -> {
            if (!stack.method_7960()) {
                String itemName = stack.method_7954().getString();
                int count = stack.method_7947();
                names.add(String.format("%sx%s", itemName, count));
            }
        });
        if (names.isEmpty()) {
            return "空的";
        }
        return StringUtils.join(names, ", ");
    }

    private static String getHealthyInfo(EntityMaid maid) {
        float maxHealth = maid.method_6063();
        float health = maid.method_6032();
        return String.format("%s (max %s)", health, maxHealth);
    }

    private static String getOwnerHealthyInfo(EntityMaid maid) {
        class_1309 owner = maid.method_35057();
        if (owner != null) {
            float maxHealth = owner.method_6063();
            float health = owner.method_6032();
            return String.format("%s (max %s)", health, maxHealth);
        }
        return StringUtils.EMPTY;
    }

    private static String getOwnerName(EntityMaid maid) {
        String ownerName = maid.getAiChatManager().getOwnerName();
        if (StringUtils.isBlank(ownerName)) {
            return "主人";
        }
        return ownerName;
    }

    private static String getWeather(class_1937 level) {
        if (level.method_8546()) {
            return "雷雨天";
        }
        if (level.method_8419()) {
            return "阴雨天";
        }
        return "晴天";
    }

    private static String getTime(class_1937 level) {
        long time = level.method_8532();
        long hours = (time / 1000 + 6) % 24;
        long minutes = (time % 1000) / (50 / 3);
        return String.format("%02d:%02d", hours, minutes);
    }

    private static String getDimension(class_1937 level) {
        class_5321<class_1937> dimension = level.method_27983();
        if (dimension == class_1937.field_25179) {
            return "主世界";
        }
        if (dimension == class_1937.field_25180) {
            return "下界";
        }
        if (dimension == class_1937.field_25181) {
            return "末地";
        }
        return dimension.method_29177().toString();
    }

    private static String getSlotItemName(class_1304 slot, EntityMaid maid) {
        class_1799 stack = maid.method_6118(slot);
        if (stack.method_7960()) {
            return "空的";
        }
        String itemName = stack.method_7954().getString();
        int count = stack.method_7947();
        return String.format("%sx%s", itemName, count);
    }

    private static String getInventoryItems(EntityMaid maid) {
        List<String> names = new ArrayList<>();
        RangedWrapper backpack = maid.getAvailableBackpackInv();
        for (int i = 0; i < backpack.getSlots(); i++) {
            class_1799 stack = backpack.getStackInSlot(i);
            if (!stack.method_7960()) {
                String itemName = stack.method_7954().getString();
                int count = stack.method_7947();
                names.add(String.format("%sx%s", itemName, count));
            }
        }
        if (names.isEmpty()) {
            return "空的";
        }
        return StringUtils.join(names, ", ");
    }

    private static String getOutputJsonFormat() {
        return Service.GSON.toJson(new ResponseChat());
    }
}
