package com.github.tartaricacid.touhoulittlemaid.api.bauble;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import org.apache.commons.lang3.StringUtils;

import java.util.Random;
import net.minecraft.class_1799;

public interface IMaidBauble {
    Random RANDOM = new Random();

    /**
     * Maid tick the bauble
     *
     * @param maid       EntityMaid
     * @param baubleItem ItemStack
     */
    default void onTick(EntityMaid maid, class_1799 baubleItem) {
    }

    /**
     * Get a chat bubble when maid has the bauble
     *
     * @return chat bubble id
     */
    default String getChatBubbleId() {
        return StringUtils.EMPTY;
    }
}
