package com.github.tartaricacid.touhoulittlemaid.api.event;

import cn.sh1rocu.touhoulittlemaid.api.event.CancellableEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;

/**
 * 这个事件会在玩家主手右击女仆时进行触发。<br>
 * 这个事件是 {@link #isCanceled() canceled}，如果取消，那么后续的所有右击事件判定都会被取消。<br>
 * 该事件会在客户端和服务端同时触发。
 */

public class InteractMaidEvent extends CancellableEvent {
    private final class_1937 world;
    private final class_1657 player;
    private final EntityMaid maid;
    private final class_1799 stack;

    public InteractMaidEvent(class_1657 player, EntityMaid maid, class_1799 stack) {
        this.player = player;
        this.world = player.method_37908();
        this.maid = maid;
        this.stack = stack;
    }

    public class_1657 getPlayer() {
        return player;
    }

    public EntityMaid getMaid() {
        return maid;
    }

    public class_1799 getStack() {
        return stack;
    }

    public class_1937 getWorld() {
        return world;
    }

    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
                for (Callback callback : callbacks) {
                    callback.post(event);
                }
            }
    );

    public interface Callback {
        void post(InteractMaidEvent event);
    }
}
