package com.github.tartaricacid.touhoulittlemaid.block;

import cn.sh1rocu.touhoulittlemaid.api.extension.IBlock;
import cn.sh1rocu.touhoulittlemaid.util.itemhandler.ItemHandlerHelper;
import cn.sh1rocu.touhoulittlemaid.util.particle.ParticleUtil;
import com.github.tartaricacid.touhoulittlemaid.crafting.AltarRecipe;
import com.github.tartaricacid.touhoulittlemaid.data.PowerAttachment;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment;
import com.github.tartaricacid.touhoulittlemaid.init.InitRecipes;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityAltar;
import com.github.tartaricacid.touhoulittlemaid.util.PosListData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_727;
import net.minecraft.class_9062;
import net.minecraft.class_9694;
import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

import static com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble.RANDOM;


public class BlockAltar extends class_2248 implements class_2343, IBlock {
    @Environment(EnvType.CLIENT)
    @Override
    public boolean addHitEffects(class_2680 state, class_1937 world, class_239 target, class_702 manager) {
        if (target instanceof class_3965 blockTarget && world instanceof class_638 clientLevel) {
            class_2338 pos = blockTarget.method_17777();
            this.getAltar(world, pos).ifPresent(altar -> this.crack(clientLevel, pos, altar.getStorageState(), blockTarget.method_17780()));
        }
        return true;
    }

    @Environment(EnvType.CLIENT)
    @Override
    public boolean addDestroyEffects(class_2680 state, class_1937 world, class_2338 pos, class_702 manager) {
        this.getAltar(world, pos).ifPresent(altar -> class_310.method_1551().field_1713.method_3046(pos, altar.getStorageState()));
        return true;
    }

    private Optional<TileEntityAltar> getAltar(class_1922 world, class_2338 pos) {
        class_2586 te = world.method_8321(pos);
        if (te instanceof TileEntityAltar) {
            return Optional.of((TileEntityAltar) te);
        }
        return Optional.empty();
    }

    @Environment(EnvType.CLIENT)
    private void crack(class_638 world, class_2338 pos, class_2680 state, class_2350 side) {
        if (state.method_26217() != class_2464.field_11455) {
            int posX = pos.method_10263();
            int posY = pos.method_10264();
            int posZ = pos.method_10260();
            class_238 aabb = state.method_26218(world, pos).method_1107();
            double x = posX + world.field_9229.method_43058() * (aabb.field_1320 - aabb.field_1323 - 0.2) + 0.1 + aabb.field_1323;
            double y = posY + world.field_9229.method_43058() * (aabb.field_1325 - aabb.field_1322 - 0.2) + 0.1 + aabb.field_1322;
            double z = posZ + world.field_9229.method_43058() * (aabb.field_1324 - aabb.field_1321 - 0.2) + 0.1 + aabb.field_1321;
            if (side == class_2350.field_11033) {
                y = posY + aabb.field_1322 - 0.1;
            }
            if (side == class_2350.field_11036) {
                y = posY + aabb.field_1325 + 0.1;
            }
            if (side == class_2350.field_11043) {
                z = posZ + aabb.field_1321 - 0.1;
            }
            if (side == class_2350.field_11035) {
                z = posZ + aabb.field_1324 + 0.1;
            }
            if (side == class_2350.field_11039) {
                x = posX + aabb.field_1323 - 0.1;
            }
            if (side == class_2350.field_11034) {
                x = posX + aabb.field_1320 + 0.1;
            }
            class_727 diggingParticle = new class_727(world, x, y, z, 0, 0, 0, state);
            class_310.method_1551().field_1713.method_3058(ParticleUtil.updateSprite(diggingParticle, state, pos).method_3075(0.2f).method_3087(0.6f));
        }
    }

    public BlockAltar() {
        super(class_4970.class_2251.method_9637().method_9626(class_2498.field_11544).method_9629(2, 2).method_22488());
    }

    @Nullable
    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new TileEntityAltar(pos, state);
    }

    @Override
    public class_9062 method_55765(class_1799 itemStack, class_2680 state, class_1937 worldIn, class_2338 pos, class_1657 player, class_1268 handIn, class_3965 hit) {
        return this.getAltar(worldIn, pos).filter(altar -> handIn == class_1268.field_5808).map(altar -> {
            if (player.method_5715() || player.method_6047().method_7960()) {
                takeOutItem(worldIn, altar, player);
            } else {
                takeInOrCraft(worldIn, altar, player);
            }
            altar.refresh();
            return class_9062.method_55644(worldIn.field_9236);
        }).orElse(super.method_55765(itemStack, state, worldIn, pos, player, handIn, hit));
    }

    @Override
    public void method_9536(class_2680 state, class_1937 worldIn, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (!worldIn.field_9236) {
            this.getAltar(worldIn, pos).ifPresent(altar -> {
                class_1799 stack = altar.handler.getStackInSlot(0);
                if (!stack.method_7960()) {
                    class_2248.method_9577(worldIn, pos.method_10069(0, 1, 0), stack);
                }
            });
        }
        super.method_9536(state, worldIn, pos, newState, isMoving);
    }

    @Override
    public void onBlockExploded(class_2680 state, class_1937 world, class_2338 pos, class_1927 explosion) {
        if (!world.field_9236) {
            this.getAltar(world, pos).ifPresent(altar -> this.restoreStorageBlock(world, pos, altar.getBlockPosList()));
        }
        IBlock.super.onBlockExploded(state, world, pos, explosion);
    }

    @Override
    public class_2680 method_9576(class_1937 worldIn, class_2338 pos, class_2680 state, class_1657 player) {
        if (!worldIn.field_9236) {
            this.getAltar(worldIn, pos).ifPresent(altar -> {
                this.restoreStorageBlock(worldIn, pos, altar.getBlockPosList());
                if (!player.method_7337()) {
                    class_2248 block = altar.getStorageState().method_26204();
                    class_2248.method_9577(worldIn, pos, new class_1799(block));
                }
            });
        }
        return super.method_9576(worldIn, pos, state, player);
    }

    @Override
    //public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, @NotNull LevelReader world, @NotNull BlockPos pos, @NotNull Player player) {
    public class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state) {
        return this.getAltar(world, pos)
                .map(altar -> new class_1799(altar.getStorageState().method_26204()))
                .orElse(super.method_9574(world, pos, state));
    }

    @Override
    //public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity) {
    public class_2498 method_9573(class_2680 state) {
        return state.method_26231();
/*        return this.getAltar()
                .map(altar -> altar.getStorageState().getSoundType())
                .orElse(super.getSoundType(state, world, pos, entity));*/
    }


    @Override
    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11456;
    }

    @Override
    public boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    private void restoreStorageBlock(class_1937 worldIn, class_2338 currentPos, PosListData posList) {
        for (class_2338 storagePos : posList.getData()) {
            if (storagePos.equals(currentPos)) {
                continue;
            }
            this.getAltar(worldIn, storagePos).ifPresent(altar -> worldIn.method_8652(storagePos, altar.getStorageState(), class_2248.field_31036));
        }
    }

    private void takeOutItem(class_1937 world, TileEntityAltar altar, class_1657 player) {
        if (altar.isCanPlaceItem()) {
            if (!altar.handler.getStackInSlot(0).method_7960()) {
                class_1799 extractItem = altar.handler.extractItem(0, 1, false);
                ItemHandlerHelper.giveItemToPlayer(player, extractItem);
                altarCraft(world, altar, player);
            }
        }
    }

    private void takeInOrCraft(class_1937 world, TileEntityAltar altar, class_1657 playerIn) {
        if (altar.isCanPlaceItem() && altar.handler.getStackInSlot(0).method_7960()) {
            altar.handler.setStackInSlot(0, playerIn.method_6047().method_46651(1));
            if (!playerIn.method_7337()) {
                playerIn.method_6047().method_7934(1);
            }
            altarCraft(world, altar, playerIn);
        }
    }

    private void altarCraft(class_1937 world, TileEntityAltar altar, class_1657 playerIn) {
        List<class_1799> arrayList = new ArrayList<>();
        List<class_2338> posList = altar.getCanPlaceItemPosList().getData();
        for (int i = 0; i < posList.size(); i++) {
            class_2586 te = world.method_8321(posList.get(i));
            if (te instanceof TileEntityAltar) {
                arrayList.add(i, ((TileEntityAltar) te).getStorageItem());
            }
        }
        if (arrayList.isEmpty()) {
            return;
        }
        class_9694 craftingInput = class_9694.method_59986(6, 1, arrayList);
        PowerAttachment powerAttachment = playerIn.getAttachedOrCreate(InitDataAttachment.POWER_NUM, () -> new PowerAttachment(0));
        world.method_8433().method_8132(InitRecipes.ALTAR_CRAFTING, craftingInput, world)
                .ifPresent(recipe -> spawnResultEntity(world, playerIn, powerAttachment, recipe.comp_1932(), recipe.comp_1933(), arrayList, altar));
    }

    private void spawnResultEntity(class_1937 world, class_1657 playerIn, PowerAttachment power, class_2960 altarId,
                                   AltarRecipe altarRecipe, List<class_1799> inventory, TileEntityAltar altar) {
        if (power.get() >= altarRecipe.getPower()) {
            power.min(altarRecipe.getPower());
            playerIn.setAttached(InitDataAttachment.POWER_NUM, new PowerAttachment(power.get()));
            class_2338 centrePos = getCentrePos(altar.getBlockPosList(), altar.method_11016());
            if (world instanceof class_3218) {
                altarRecipe.spawnOutputEntity((class_3218) world, centrePos.method_10086(2), inventory);
            }
            removeAllAltarItem(world, altar);
            spawnParticleInCentre(world, centrePos);
            world.method_8396(null, centrePos, InitSounds.ALTAR_CRAFT, class_3419.field_15246, 1.0f, 1.0f);
            if (playerIn instanceof class_3222 serverPlayer) {
                InitTrigger.ALTAR_CRAFT.trigger(serverPlayer, altarId);
            }
        } else {
            if (!world.field_9236) {
                playerIn.method_43496(class_2561.method_43471("message.touhou_little_maid.altar.not_enough_power"));
            }
        }
    }

    private class_2338 getCentrePos(PosListData posList, class_2338 posClick) {
        int x = 0;
        int y = posClick.method_10264() - 2;
        int z = 0;
        for (class_2338 pos : posList.getData()) {
            if (pos.method_10264() == y) {
                x += pos.method_10263();
                z += pos.method_10260();
            }
        }
        return new class_2338(x / 8, y, z / 8);
    }

    private void removeAllAltarItem(class_1937 world, TileEntityAltar altar) {
        for (class_2338 pos : altar.getCanPlaceItemPosList().getData()) {
            this.getAltar(world, pos).ifPresent(te -> {
                te.handler.setStackInSlot(0, class_1799.field_8037);
                te.refresh();
                spawnParticleInCentre(world, te.method_11016());
            });
        }
    }

    private void spawnParticleInCentre(class_1937 world, class_2338 centrePos) {
        int width = 1;
        int height = 1;
        for (int i = 0; i < 5; ++i) {
            double xSpeed = RANDOM.nextGaussian() * 0.02;
            double ySpeed = RANDOM.nextGaussian() * 0.02;
            double zSpeed = RANDOM.nextGaussian() * 0.02;
            world.method_8406(class_2398.field_11204,
                    centrePos.method_10263() + RANDOM.nextFloat() * width * 2 - width - xSpeed * 10,
                    centrePos.method_10264() + RANDOM.nextFloat() * height - ySpeed * 10,
                    centrePos.method_10260() + RANDOM.nextFloat() * width * 2 - width - zSpeed * 10,
                    xSpeed, ySpeed, zSpeed);
            world.method_8406(class_2398.field_11251,
                    centrePos.method_10263() + RANDOM.nextFloat() * width * 2 - width - xSpeed * 10,
                    centrePos.method_10264() + RANDOM.nextFloat() * height - ySpeed * 10,
                    centrePos.method_10260() + RANDOM.nextFloat() * width * 2 - width - zSpeed * 10,
                    xSpeed, ySpeed, zSpeed);
        }
    }
}
