package com.github.tartaricacid.touhoulittlemaid.client.gui.entity.model;

import cn.sh1rocu.touhoulittlemaid.mixin.accessor.ScreenAccessor;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.ImageButtonWithId;
import com.github.tartaricacid.touhoulittlemaid.client.gui.widget.button.TouhouImageButton;
import com.github.tartaricacid.touhoulittlemaid.client.renderer.texture.SizeTexture;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.CustomModelPack;
import com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.IModelInfo;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.util.ParseI18n;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_1044;
import net.minecraft.class_1049;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import java.util.ArrayList;
import java.util.List;

import static com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo.ENCRYPT_EGG_NAME;
import static com.github.tartaricacid.touhoulittlemaid.client.resource.pojo.MaidModelInfo.NORMAL_EGG_NAME;

public abstract class AbstractModelGui<T extends class_1309, E extends IModelInfo> extends class_437 {
    public static final class_4185.class_4241 NO_PRESS = (b) -> {
    };
    private static final class_2960 BG = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/skin_select.png");
    private static final class_2960 SIDE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/skin_select_side.png");
    private static final class_2960 EMPTY_ICON = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/gui/empty_model_pack_icon.png");
    private static final class_1049 EMPTY_ICON_TEXTURE = new class_1049(EMPTY_ICON);
    protected final T entity;
    private final SkinGuiNumber<E> guiNumber;
    private final List<CustomModelPack<E>> modelPackList;

    public AbstractModelGui(T entity, List<CustomModelPack<E>> listPack) {
        super(class_2561.method_43470("Custom Model GUI"));
        this.entity = entity;
        this.modelPackList = listPack;
        this.guiNumber = new SkinGuiNumber<>(modelPackList);
        setPageIndex(class_3532.method_15340(getPageIndex(), 0, guiNumber.getPageSize() - 1));
        setPackIndex(class_3532.method_15340(getPackIndex(), 0, guiNumber.getPackSize() - 1));
        setRowIndex(class_3532.method_15340(getRowIndex(), 0, guiNumber.getRowSize(getPackIndex())));
    }

    /**
     * 绘制左侧示例实体
     *
     * @param middleX 屏幕参考中点
     * @param middleY 屏幕参考中点
     * @param mouseX  鼠标 x 坐标
     * @param mouseY  鼠标 Y 坐标
     */
    protected abstract void drawLeftEntity(class_332 graphics, int middleX, int middleY, float mouseX, float mouseY);

    /**
     * 绘制右侧示例实体
     *
     * @param posX      实体所在的 x 坐标
     * @param posY      实体所在的 y 坐标
     * @param modelItem 该实体应该对应的模型数据
     */
    protected abstract void drawRightEntity(class_332 graphics, int posX, int posY, E modelItem);

    /**
     * 打开详情界面
     *
     * @param entity    实体
     * @param modelInfo 该实体应该对应的模型数据
     */
    protected abstract void openDetailsGui(T entity, E modelInfo);

    /**
     * 发包通知模型更改
     *
     * @param entity    实体
     * @param modelInfo 该实体应该对应的模型数据
     */
    protected abstract void notifyModelChange(T entity, E modelInfo);

    protected abstract void addModelCustomTips(E modelItem, List<class_2561> tooltips);

    protected abstract int getPackIndex();

    protected abstract void setPackIndex(int packIndex);

    protected abstract int getRowIndex();

    protected abstract void setRowIndex(int rowIndex);

    protected abstract int getPageIndex();

    protected abstract void setPageIndex(int packIndex);

    @Override
    public void method_25426() {
        // 清除按钮列表、标签列表，用来给后面重载按键用的
        this.method_37067();

        int startX = this.field_22789 / 2 + 50;
        int startY = this.field_22790 / 2 + 5;

        // 模型包的分栏按钮
        for (int index = 0; index < 7; index++) {
            addTabButton(startX, startY, index);
        }

        // 关闭当前界面的按键
        this.method_37063(new TouhouImageButton(startX + 122, startY - 97, 21, 17, 58, 201, 18, BG,
                (b) -> Screens.getClient(this).method_20493(() -> Screens.getClient(this).method_1507(null))));

        // 添加切换页面的按钮
        addPageButton(startX, startY);

        // 添加切换模型的按钮
        addModelButton(startX, startY);

        // 模型包翻页
        addScrollButton(startX, startY);

        // 添加开启、关闭模型包图标缓存的按钮
        class_5250 enableCache = class_2561.method_43471("gui.touhou_little_maid.skin.enable_cache");
        int checkBoxWidth = field_22793.method_27525(enableCache) + 20;
        int xOffset = (startX - 256 / 2) / 2 - checkBoxWidth / 2;
        class_4286 cacheCheckBox = class_4286.method_54787(enableCache, field_22793)
                .method_54789(xOffset, startY - 101)
                .method_54794(MiscConfig.MODEL_ICON_CACHE.get())
                .method_54791((checkBox, value) -> MiscConfig.MODEL_ICON_CACHE.set(value))
                .method_54788();
        this.method_37063(cacheCheckBox);
    }

    private void addModelButton(int startX, int startY) {
        // 添加按键，顺便装填按键对应模型的索引
        CustomModelPack<E> pack = modelPackList.get(getPackIndex());

        // 起始坐标
        int offsetX = -100;
        int offsetY = -35;

        // 切割列表，让其一页最多显示 44 个模型，但是又不至于溢出
        int fromIndex = guiNumber.modelFromIndex(getRowIndex());
        int toIndex = guiNumber.modelToIndex(getPackIndex(), getRowIndex());

        // 开始添加按键，顺便装填按键对应模型的索引
        for (E modelItem : pack.getModelList().subList(fromIndex, toIndex)) {
            this.method_37063(new TouhouImageButton(startX + offsetX - 8, startY + offsetY - 26, 15, 24, 41, 201, 24, BG, onModelButtonClick(modelItem)));

            // 往右绘制
            offsetX = offsetX + 20;

            // 如果超出一定限制，换行
            if (offsetX > 105) {
                offsetX = -100;
                offsetY = offsetY + 30;
            }
        }
    }

    private void addScrollButton(int startX, int startY) {
        TouhouImageButton upButton = new TouhouImageButton(startX - 256 / 2 + 253, startY - 73, 14, 10, 24, 15, 10, SIDE, b -> {
            int row = class_3532.method_15340(getRowIndex() - 1, 0, guiNumber.getRowSize(getPackIndex()));
            if (row != getRowIndex()) {
                setRowIndex(row);
                this.method_25426();
            }
        });
        class_4185 downButton = new TouhouImageButton(startX - 256 / 2 + 253, startY - 73 + 156, 14, 10, 38, 15, 10, SIDE, b -> {
            int row = class_3532.method_15340(getRowIndex() + 1, 0, guiNumber.getRowSize(getPackIndex()));
            if (row != getRowIndex()) {
                setRowIndex(row);
                this.method_25426();
            }
        });
        this.method_37063(upButton);
        this.method_37063(downButton);
    }

    private class_4185.class_4241 onModelButtonClick(E modelItem) {
        return (button) -> {
            if (method_25442()) {
                openDetailsGui(entity, modelItem);
            } else {
                notifyModelChange(entity, modelItem);
            }
        };
    }

    private void addPageButton(int startX, int startY) {
        class_4185 prePage = class_4185.method_46430(class_2561.method_43470("<"), b -> {
            setRowIndex(0);
            setPageIndex(class_3532.method_15340(getPageIndex() - 1, 0, guiNumber.getPageSize() - 1));
            setPackIndex(guiNumber.tabToPackIndex(0, getPageIndex()));
            this.method_25426();
        }).method_46433(startX - 119, startY - 101).method_46437(20, 20).method_46431();
        class_4185 nextPage = class_4185.method_46430(class_2561.method_43470(">"), b -> {
            setRowIndex(0);
            setPageIndex(class_3532.method_15340(getPageIndex() + 1, 0, guiNumber.getPageSize() - 1));
            setPackIndex(guiNumber.tabToPackIndex(0, getPageIndex()));
            this.method_25426();
        }).method_46433(startX + 99, startY - 101).method_46437(20, 20).method_46431();
        if (getPageIndex() == 0) {
            prePage.field_22763 = false;
        }
        if (getPageIndex() == guiNumber.getPageSize() - 1) {
            nextPage.field_22763 = false;
        }
        this.method_37063(prePage);
        this.method_37063(nextPage);
    }

    private void addTabButton(int startX, int startY, int index) {
        if (index == guiNumber.getTabIndex(getPackIndex())) {
            this.method_37063(new TouhouImageButton(startX - 98 + 28 * index, startY - 108, 28, 31, 116, 224, 0, BG, NO_PRESS));
        } else if (index < guiNumber.getTabSize(getPackIndex())) {
            this.method_37063(new ImageButtonWithId(index, startX - 98 + 28 * index, startY - 105, 28, 25, 116, 194, 0, BG,
                    (b) -> {
                        setRowIndex(0);
                        setPackIndex(guiNumber.tabToPackIndex(((ImageButtonWithId) b).getIndex(), getPageIndex()));
                        this.method_25426();
                    }));
        } else {
            TouhouImageButton buttonImage = new TouhouImageButton(startX - 98 + 28 * index, startY - 105, 28, 25, 116, 194, 0, BG, NO_PRESS);
            buttonImage.field_22764 = false;
            this.method_37063(buttonImage);
        }
    }

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_57734(partialTicks);

        graphics.method_51448().method_46416(0, 0, -100);

        // 中心点
        int middleX = this.field_22789 / 2 + 50;
        int middleY = this.field_22790 / 2 + 5;

        // 绘制灰色默认背景
        method_25420(graphics, mouseX, mouseY, partialTicks);

        // 绘制 GUI 背景
        graphics.method_25302(BG, middleX - 256 / 2, middleY - 80, 0, 0, 256, 180);
        graphics.method_25302(SIDE, middleX - 256 / 2 + 250, middleY - 80, 0, 0, 24, 180);

        // 绘制侧边的滚动条
        drawScrollSide(graphics, middleX, middleY);

        // 调用父类方法绘制按钮列表、标签列表
        drawButton(graphics, mouseX, mouseY, partialTicks);

        // 绘制标签栏图标
        drawTabIcon(graphics, middleX, middleY);

        // 绘制左边示例实体
        drawLeftEntity(graphics, middleX, middleY, mouseX, mouseY);

        // 绘制实体，绘制完毕后绘制文本提示
        drawEntity(graphics, middleX, middleY);

        // 绘制其他文本提示
        drawTooltips(graphics, mouseX, mouseY, middleX, middleY);
    }

    private void drawButton(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        for (class_4068 button : ((ScreenAccessor) this).tlm$getRenderables()) {
            button.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
    }

    private void drawScrollSide(class_332 graphics, int middleX, int middleY) {
        if (guiNumber.canScroll(getPackIndex(), getRowIndex())) {
            graphics.method_25302(SIDE, middleX - 256 / 2 + 254,
                    middleY - 61 + (int) (127 * guiNumber.getCurrentScroll(getPackIndex(), getRowIndex())),
                    24, 0, 12, 15);
        } else {
            graphics.method_25302(SIDE, middleX - 256 / 2 + 254,
                    middleY - 61 + (int) (127 * guiNumber.getCurrentScroll(getPackIndex(), getRowIndex())),
                    36, 0, 12, 15);
        }
    }

    private void drawTabIcon(class_332 graphics, int middleX, int middleY) {
        // 模型包的分栏按钮图标
        int size = guiNumber.getTabSize(getPackIndex());
        for (int index = 0; index < size; index++) {
            CustomModelPack<E> pack = modelPackList.get(guiNumber.tabToPackIndex(index, getPageIndex()));
            class_2960 icon = pack.getIcon();
            if (icon != null) {
                class_1044 iconTexture = class_310.method_1551().method_1531().method_34590(icon, EMPTY_ICON_TEXTURE);
                if (EMPTY_ICON_TEXTURE.equals(iconTexture)) {
                    icon = EMPTY_ICON;
                }
                if (pack.getIconAnimation() == CustomModelPack.AnimationState.UNCHECK) {
                    checkIconAnimation(pack, icon);
                }
                if (pack.getIconAnimation() == CustomModelPack.AnimationState.FALSE) {
                    graphics.method_25290(icon, middleX - 92 + 28 * index, middleY - 98,
                            0, 0, 16, 16, 16, 16);
                } else {
                    RenderSystem.setShader(class_757::method_34542);
                    RenderSystem.setShaderTexture(0, icon);
                    int time = getTickTime() / pack.getIconDelay();
                    int iconIndex = time % pack.getIconAspectRatio();
                    graphics.method_25290(icon, middleX - 92 + 28 * index, middleY - 98,
                            0, iconIndex * 16, 16,
                            16, 16, 16 * pack.getIconAspectRatio());
                }
            }
        }
    }

    private int getTickTime() {
        return (int) System.currentTimeMillis() / 50;
    }

    private void checkIconAnimation(CustomModelPack<E> pack, class_2960 icon) {
        class_1044 iconText = Screens.getClient(this).method_1531().method_4619(icon);
        if (iconText instanceof SizeTexture) {
            int width = ((SizeTexture) iconText).getWidth();
            int height = ((SizeTexture) iconText).getHeight();
            if (width >= height) {
                pack.setIconAnimation(CustomModelPack.AnimationState.FALSE);
            } else {
                pack.setIconAnimation(CustomModelPack.AnimationState.TRUE);
                pack.setIconAspectRatio(height / width);
            }
        } else {
            pack.setIconAnimation(CustomModelPack.AnimationState.FALSE);
        }
    }

    /**
     * 绘制所有的模型实体图案
     */
    private void drawEntity(class_332 graphics, int middleX, int middleY) {
        // 获取当前包索引得到的模型列表
        CustomModelPack<E> pack = modelPackList.get(getPackIndex());

        // 绘制包信息
        drawPackInfoText(graphics, pack, middleX, middleY);

        // 起始坐标
        int offsetX = -100;
        int offsetY = -38;

        // 切割列表，让其一页最多显示 PAGE_MAX_NUM 个模型，但是又不至于溢出
        int fromIndex = guiNumber.modelFromIndex(getRowIndex());
        int toIndex = guiNumber.modelToIndex(getPackIndex(), getRowIndex());

        // 开始绘制实体图案，并往上添加对应模型和材质
        for (E modelItem : pack.getModelList().subList(fromIndex, toIndex)) {
            drawRightEntity(graphics, middleX + offsetX, middleY + offsetY, modelItem);
            // 往右绘制
            offsetX = offsetX + 20;
            // 如果超出一定限制，换行
            if (offsetX > 105) {
                offsetX = -100;
                offsetY = offsetY + 30;
            }
        }
    }

    /**
     * 绘制包的文本信息
     */
    private void drawPackInfoText(class_332 graphics, CustomModelPack<E> pack, int middleX, int middleY) {
        int offsetY = -80;
        int sideMiddleX = (middleX - 256 / 2) / 2;

        // 绘制包名
        class_5250 packName = ParseI18n.parse(pack.getPackName());
        List<class_5348> packSplitName = field_22793.method_27527().method_27495(packName, (middleX - 256 / 2) - 20, class_2583.field_24360);
        for (class_5348 properties : packSplitName) {
            offsetY += 10;
            graphics.method_25300(field_22793, properties.getString(), sideMiddleX, middleY + offsetY, 0xffffff);
        }

        // 如果描述不为空，逐行绘制描述
        for (class_2561 str : ParseI18n.parse(pack.getDescription())) {
            List<class_5348> split = field_22793.method_27527().method_27495(str, (middleX - 256 / 2) - 20, class_2583.field_24360);
            for (class_5348 properties : split) {
                offsetY += 10;
                graphics.method_25300(field_22793, properties.getString(), sideMiddleX, middleY + offsetY, 0x777777);
            }
        }

        // 绘制作者列表
        if (!pack.getAuthor().isEmpty()) {
            for (List<String> textList : Lists.partition(pack.getAuthor(), 2)) {
                offsetY += 10;
                graphics.method_27534(field_22793, class_2561.method_43470(textList.toString()).method_27692(class_124.field_1065),
                        sideMiddleX, middleY + offsetY, 0xffffff);
            }
        }

        // 绘制版本信息
        if (pack.getVersion() != null) {
            offsetY += 10;
            graphics.method_27534(field_22793, class_2561.method_43469("gui.touhou_little_maid.skin.text.version", pack.getVersion())
                            .method_27692(class_124.field_1062),
                    sideMiddleX, middleY + offsetY, 0xffffff);
        }

        // 绘制日期信息
        if (pack.getDate() != null) {
            offsetY += 10;
            graphics.method_27534(field_22793, class_2561.method_43469("gui.touhou_little_maid.skin.text.date", pack.getDate())
                            .method_27692(class_124.field_1060),
                    sideMiddleX, middleY + offsetY, 0xffffff);
        }

        // 绘制最后的翻页数
        graphics.method_25300(field_22793, String.format("%s/%s", getPageIndex() + 1, guiNumber.getPageSize()), middleX, middleY - 120, 0xffffff);
    }

    /**
     * 绘制模型对应的文本提示<br>
     * 用遍历方式绘制文本提示，因为绝大多数情况下是空循环体（可能就涉及几个简单的 int 运算）<br>
     * 应该不会存在性能问题<br>
     */
    private void drawTooltips(class_332 graphics, int mouseX, int mouseY, int middleX, int middleY) {
        // 获取当前包索引得到的模型列表
        CustomModelPack<E> pack = modelPackList.get(getPackIndex());

        // 起始坐标
        int offsetX = -100;
        int offsetY = -35;

        // 切割列表，让其一页最多显示 44 个模型，但是又不至于溢出
        int fromIndex = guiNumber.modelFromIndex(getRowIndex());
        int toIndex = guiNumber.modelToIndex(getPackIndex(), getRowIndex());

        // 开始绘制实体图案，并往上添加对应模型和材质
        for (E modelItem : pack.getModelList().subList(fromIndex, toIndex)) {
            // 判定鼠标所在的位置
            boolean isxInRange = middleX + offsetX - 8 < mouseX && mouseX < middleX + offsetX + 7;
            boolean isyInRange = middleY + offsetY - 23 < mouseY && mouseY < middleY + offsetY + 1;

            // 在位置内，就绘制文本提示
            if (isxInRange && isyInRange) {
                // 绘制的文本
                List<String> str = new ArrayList<>();
                // 塞入模型名称
                str.add(modelItem.getName());
                // 塞入描述
                str.addAll(modelItem.getDescription());
                // 转换为 ITextComponent
                List<class_2561> tooltips = ParseI18n.parse(str);
                // 添加额外的提示
                addModelCustomTips(modelItem, tooltips);
                // 塞入提示语
                if (!modelItem.getName().equals(ENCRYPT_EGG_NAME) && !modelItem.getName().equals(NORMAL_EGG_NAME)) {
                    tooltips.add(class_2561.method_43471("gui.touhou_little_maid.skin.tooltips.show_details")
                            .method_27692(class_124.field_1064));
                }
                // 当开启显示更多物品信息功能时，显示模型 ID
                if (Screens.getClient(this).field_1690.field_1827) {
                    tooltips.add(class_2561.method_43470(modelItem.getModelId().toString()).method_27692(class_124.field_1063));
                }
                tooltips.add(ParseI18n.parse(pack.getPackName()).method_27692(class_124.field_1078));
                // 绘制解析过的文本提示
                graphics.method_51434(field_22793, tooltips, mouseX, mouseY);
            }

            // 往右绘制
            offsetX = offsetX + 20;

            // 如果超出一定限制，换行
            if (offsetX > 105) {
                offsetX = -100;
                offsetY = offsetY + 30;
            }
        }

        // 绘制标签页的文本提示
        int size = guiNumber.getTabSize(getPackIndex());
        for (int index = 0; index < size; index++) {
            boolean isxInRange = middleX - 98 + 28 * index < mouseX && mouseX < middleX - 98 + 28 * index + 28;
            boolean isyInRange = middleY - 108 < mouseY && mouseY < middleY - 108 + 31;
            if (isxInRange && isyInRange) {
                CustomModelPack<E> hoverPack = modelPackList.get(guiNumber.tabToPackIndex(index, getPageIndex()));
                graphics.method_51438(field_22793, ParseI18n.parse(hoverPack.getPackName()), mouseX, mouseY);
            }
        }

        // 绘制关闭按钮的文本提示
        boolean xInRange = (middleX + 122) < mouseX && mouseX < (middleX + 143);
        boolean yInRange = (middleY - 97) < mouseY && mouseY < (middleY - 80);
        if (xInRange && yInRange) {
            graphics.method_51438(field_22793, class_2561.method_43471("gui.touhou_little_maid.skin.button.close"), mouseX, mouseY);
        }
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (deltaY != 0) {
            int index = 0;
            // 向上滚
            if (deltaY > 0) {
                index = 1;
            }
            // 向下滚
            if (deltaY < 0) {
                index = -1;
            }
            int row = class_3532.method_15340(getRowIndex() - index, 0, guiNumber.getRowSize(getPackIndex()));
            if (row != getRowIndex()) {
                setRowIndex(row);
                this.method_25426();
                return true;
            }
        }
        return super.method_25401(mouseX, mouseY, deltaX, deltaY);
    }

    @Override
    public boolean method_25421() {
        return false;
    }
}
