package com.github.tartaricacid.touhoulittlemaid.client.model;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockPart;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.BedrockModelPOJO;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.BedrockVersion;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

public class CChessPiecesModel {
    private static final class_2960 MODEL = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "models/entity/cchess_pieces.json");
    private static BedrockModel<class_1309> bedrockModel;
    private final BedrockPart main;

    public CChessPiecesModel(String name) {
        this.main = bedrockModel.getModelMap().get(name);
    }

    public static CChessPiecesModel[] initModel() {
        class_310.method_1551().method_1478().method_14486(MODEL).ifPresent(res -> {
            try (InputStream stream = res.method_14482()) {
                BedrockModelPOJO pojo = CustomPackLoader.GSON.fromJson(new InputStreamReader(stream, StandardCharsets.UTF_8), BedrockModelPOJO.class);
                bedrockModel = new BedrockModel<>(pojo, BedrockVersion.NEW);
            } catch (IOException ignore) {
            }
        });

        CChessPiecesModel[] models = new CChessPiecesModel[23];

        models[8] = new CChessPiecesModel("ShuaiRed");
        models[9] = new CChessPiecesModel("ShiRed");
        models[10] = new CChessPiecesModel("XiangRed");
        models[11] = new CChessPiecesModel("MaRed");
        models[12] = new CChessPiecesModel("JuRed");
        models[13] = new CChessPiecesModel("PaoRed");
        models[14] = new CChessPiecesModel("BingRed");

        models[16] = new CChessPiecesModel("JiangBlack");
        models[17] = new CChessPiecesModel("ShiBlack");
        models[18] = new CChessPiecesModel("XiangBlack");
        models[19] = new CChessPiecesModel("MaBlack");
        models[20] = new CChessPiecesModel("JuBlack");
        models[21] = new CChessPiecesModel("PaoBlack");
        models[22] = new CChessPiecesModel("ZuBlack");

        return models;
    }

    public static CChessPiecesModel getSelectedModel() {
        return new CChessPiecesModel("Selected");
    }

    public void renderToBuffer(class_4587 poseStack, class_4588 vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        main.render(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}
