package com.github.tartaricacid.touhoulittlemaid.client.model;


import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityBox;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5601;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;
import net.minecraft.client.model.geom.builders.*;

public class EntityBoxModel extends AbstractModel<EntityBox> {
    public static class_5601 LAYER = new class_5601(class_2960.method_60655(TouhouLittleMaid.MOD_ID, "main"), "box");
    private final class_630 bottom;
    private final class_630 x1;
    private final class_630 x2;
    private final class_630 z1;
    private final class_630 z2;
    private final class_630 top;

    public EntityBoxModel(class_630 root) {
        this.bottom = root.method_32086("bottom");
        this.x1 = root.method_32086("x1");
        this.x2 = root.method_32086("x2");
        this.z1 = root.method_32086("z1");
        this.z2 = root.method_32086("z2");
        this.top = root.method_32086("top");
    }

    public static class_5607 createBodyLayer() {
        class_5609 meshdefinition = new class_5609();
        class_5610 partdefinition = meshdefinition.method_32111();

        class_5610 bottom = partdefinition.method_32117("bottom", class_5606.method_32108().method_32101(0, 0).method_32098(-15.0F, -1.0F, -15.0F, 30.0F, 1.0F, 30.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, 24.0F, 0.0F));

        class_5610 x1 = partdefinition.method_32117("x1", class_5606.method_32108().method_32101(64, 31).method_32098(-14.0F, -30.5F, -0.5F, 28.0F, 30.0F, 1.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, 23.5F, -14.5F));

        class_5610 x2 = partdefinition.method_32117("x2", class_5606.method_32108().method_32101(64, 31).method_32098(-14.0F, -30.5F, -0.5F, 28.0F, 30.0F, 1.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, 23.5F, 14.5F));

        class_5610 z1 = partdefinition.method_32117("z1", class_5606.method_32108().method_32101(0, 31).method_32098(-0.5F, -30.5F, -15.0F, 1.0F, 30.0F, 30.0F, new class_5605(0.0F)), class_5603.method_32090(14.5F, 23.5F, 0.0F));

        class_5610 z2 = partdefinition.method_32117("z2", class_5606.method_32108().method_32101(0, 31).method_32098(-0.5F, -30.5F, -15.0F, 1.0F, 30.0F, 30.0F, new class_5605(0.0F)), class_5603.method_32090(-14.5F, 23.5F, 0.0F));

        class_5610 top = partdefinition.method_32117("top", class_5606.method_32108().method_32101(0, 0).method_32098(-15.0F, -32.0F, -15.0F, 30.0F, 1.0F, 30.0F, new class_5605(0.0F))
                .method_32101(64, 64).method_32098(-16.0F, -32.0F, -16.0F, 32.0F, 6.0F, 1.0F, new class_5605(0.0F))
                .method_32101(64, 64).method_32098(-16.0F, -32.0F, 15.0F, 32.0F, 6.0F, 1.0F, new class_5605(0.0F))
                .method_32101(32, 61).method_32098(-16.0F, -32.0F, -15.0F, 1.0F, 6.0F, 30.0F, new class_5605(0.0F))
                .method_32101(32, 61).method_32098(15.0F, -32.0F, -15.0F, 1.0F, 6.0F, 30.0F, new class_5605(0.0F)), class_5603.method_32090(0.0F, 24.0F, 0.0F));

        return class_5607.method_32110(meshdefinition, 256, 256);
    }

    @Override
    public void setupAnim(EntityBox entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        int stage = entityIn.getOpenStage();
        if (stage == EntityBox.FIRST_STAGE) {
            top.field_3665 = true;
            x1.field_3654 = 0;
            x2.field_3654 = 0;
            z1.field_3674 = 0;
            z2.field_3674 = 0;
        } else if (stage > EntityBox.SECOND_STAGE) {
            top.field_3665 = false;
            x1.field_3654 = 0;
            x2.field_3654 = 0;
            z1.field_3674 = 0;
            z2.field_3674 = 0;
        } else {
            top.field_3665 = false;
            x1.field_3654 = 0.023998277f * (EntityBox.SECOND_STAGE - stage);
            x2.field_3654 = -0.023998277f * (EntityBox.SECOND_STAGE - stage);
            z1.field_3674 = 0.023998277f * (EntityBox.SECOND_STAGE - stage);
            z2.field_3674 = -0.023998277f * (EntityBox.SECOND_STAGE - stage);
        }
    }

    @Override
    public void method_2828(class_4587 poseStack, class_4588 vertexConsumer, int packedLight, int packedOverlay, int color) {
        bottom.method_22698(poseStack, vertexConsumer, packedLight, packedOverlay);
        x1.method_22698(poseStack, vertexConsumer, packedLight, packedOverlay);
        x2.method_22698(poseStack, vertexConsumer, packedLight, packedOverlay);
        z1.method_22698(poseStack, vertexConsumer, packedLight, packedOverlay);
        z2.method_22698(poseStack, vertexConsumer, packedLight, packedOverlay);
        top.method_22698(poseStack, vertexConsumer, packedLight, packedOverlay);
    }
}