package com.github.tartaricacid.touhoulittlemaid.client.model;

import com.github.tartaricacid.simplebedrockmodel.client.bedrock.model.BedrockPart;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.BedrockModelPOJO;
import com.github.tartaricacid.simplebedrockmodel.client.bedrock.pojo.BedrockVersion;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.bedrock.BedrockModel;
import com.github.tartaricacid.touhoulittlemaid.client.resource.CustomPackLoader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;

public class WChessPiecesModel {
    private static final class_2960 MODEL = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "models/entity/wchess_pieces.json");
    private static BedrockModel<class_1309> bedrockModel;
    private final BedrockPart main;

    public WChessPiecesModel(String name) {
        this.main = bedrockModel.getModelMap().get(name);
    }

    public static WChessPiecesModel[] initModel() {
        class_310.method_1551().method_1478().method_14486(MODEL).ifPresent(res -> {
            try (InputStream stream = res.method_14482()) {
                BedrockModelPOJO pojo = CustomPackLoader.GSON.fromJson(new InputStreamReader(stream, StandardCharsets.UTF_8), BedrockModelPOJO.class);
                bedrockModel = new BedrockModel<>(pojo, BedrockVersion.NEW);
            } catch (IOException ignore) {
            }
        });

        WChessPiecesModel[] models = new WChessPiecesModel[23];

        models[8] = new WChessPiecesModel("KING_W");
        models[9] = new WChessPiecesModel("QUEEN_W");
        models[10] = new WChessPiecesModel("ROOK_W");
        models[11] = new WChessPiecesModel("BISHOP_W");
        models[12] = new WChessPiecesModel("KNIGHT_W");
        models[13] = new WChessPiecesModel("PAWN_W");

        models[16] = new WChessPiecesModel("KING_B");
        models[17] = new WChessPiecesModel("QUEEN_B");
        models[18] = new WChessPiecesModel("ROOK_B");
        models[19] = new WChessPiecesModel("BISHOP_B");
        models[20] = new WChessPiecesModel("KNIGHT_B");
        models[21] = new WChessPiecesModel("PAWN_B");

        return models;
    }

    public static WChessPiecesModel getSelectedModel() {
        return new WChessPiecesModel("SELECT");
    }

    public void renderToBuffer(class_4587 poseStack, class_4588 vertexConsumer, int packedLight, int packedOverlay) {
        poseStack.method_22903();
        poseStack.method_22905(0.9f, 0.9f, 0.9f);
        poseStack.method_22904(0, 0.175, 0);
        main.render(poseStack, vertexConsumer, packedLight, packedOverlay);
        poseStack.method_22909();
    }
}
