package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.EntityMarisaYukkuriModel;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.VanillaConfig;
import net.minecraft.class_1589;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_917;
import net.minecraft.class_927;

public class EntityMarisaYukkuriSlimeRender extends class_927<class_1589, EntityMarisaYukkuriModel> {
    private static final class_2960 TEXTURE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/entity/marisa_yukkuri.png");
    private final class_917 vanillaRender;

    public EntityMarisaYukkuriSlimeRender(class_5617.class_5618 context) {
        super(context, new EntityMarisaYukkuriModel(context.method_32167(EntityMarisaYukkuriModel.LAYER)), 0.25F);
        this.vanillaRender = new class_917(context);
    }

    @Override
    public void render(class_1589 slime, float yaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        if (VanillaConfig.REPLACE_SLIME_MODEL.get()) {
            renderYukkuri(slime, yaw, partialTicks, poseStack, buffer, packedLight);
        } else {
            vanillaRender.method_48302(slime, yaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    @Override
    protected int getBlockLightLevel(class_1589 pEntity, class_2338 pPos) {
        return 15;
    }

    private void renderYukkuri(class_1589 slime, float yaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        this.field_4673 = 0.25F * (float) slime.method_7152();
        super.method_4054(slime, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    @Override
    protected void scale(class_1589 slime, class_4587 poseStack, float partialTicks) {
        poseStack.method_22905(0.999F, 0.999F, 0.999F);
        poseStack.method_46416(0.0F, 0.001F, 0.0F);
        float slimeSize = (float) slime.method_7152();
        float tmp = class_3532.method_16439(partialTicks, slime.field_7387, slime.field_7388) / (slimeSize * 0.5F + 1.0F);
        float scale = 1.0F / (tmp + 1.0F);
        poseStack.method_22905(scale * slimeSize, 1.0F / scale * slimeSize, scale * slimeSize);
    }

    @Override
    public class_2960 getTextureLocation(class_1589 slime) {
        return TEXTURE;
    }
}
