package com.github.tartaricacid.touhoulittlemaid.client.renderer.entity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.model.EntityYukkuriModel;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.VanillaConfig;
import net.minecraft.class_1621;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5617;
import net.minecraft.class_927;
import net.minecraft.class_945;

public class EntityYukkuriSlimeRender extends class_927<class_1621, EntityYukkuriModel> {
    private static final class_2960 TEXTURE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/entity/yukkuri.png");
    private final class_945 vanillaRender;

    public EntityYukkuriSlimeRender(class_5617.class_5618 context) {
        super(context, new EntityYukkuriModel(context.method_32167(EntityYukkuriModel.LAYER)), 0.25F);
        this.vanillaRender = new class_945(context);
    }

    @Override
    public void render(class_1621 slime, float yaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        if (VanillaConfig.REPLACE_SLIME_MODEL.get()) {
            renderYukkuri(slime, yaw, partialTicks, poseStack, buffer, packedLight);
        } else {
            vanillaRender.method_4117(slime, yaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    private void renderYukkuri(class_1621 slime, float yaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        this.field_4673 = 0.25F * (float) slime.method_7152();
        super.method_4054(slime, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    @Override
    protected void scale(class_1621 slime, class_4587 poseStack, float partialTicks) {
        poseStack.method_22905(0.999F, 0.999F, 0.999F);
        poseStack.method_46416(0.0F, 0.001F, 0.0F);
        float slimeSize = (float) slime.method_7152();
        float tmp = class_3532.method_16439(partialTicks, slime.field_7387, slime.field_7388) / (slimeSize * 0.5F + 1.0F);
        float scale = 1.0F / (tmp + 1.0F);
        poseStack.method_22905(scale * slimeSize, 1.0F / scale * slimeSize, scale * slimeSize);
    }

    @Override
    public class_2960 getTextureLocation(class_1621 slime) {
        return TEXTURE;
    }
}
