package com.github.tartaricacid.touhoulittlemaid.client.renderer.tileentity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.block.BlockGomoku;
import com.github.tartaricacid.touhoulittlemaid.client.model.KeyboardModel;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityKeyboard;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;

public class TileEntityKeyboardRenderer extends TileEntityJoyRenderer<TileEntityKeyboard> {
    private static final class_2960 TEXTURE = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/entity/keyboard.png");
    private final KeyboardModel model;

    public TileEntityKeyboardRenderer(class_5614.class_5615 context) {
        model = new KeyboardModel(context.method_32140(KeyboardModel.LAYER));
    }

    @Override
    public void render(TileEntityKeyboard keyboard, float partialTick, class_4587 poseStack, class_4597 bufferIn, int combinedLightIn, int combinedOverlayIn) {
        class_2350 facing = keyboard.method_11010().method_11654(BlockGomoku.FACING);
        poseStack.method_22903();
        poseStack.method_22904(0.5, 1.5, 0.5);
        poseStack.method_22907(class_7833.field_40717.rotationDegrees(180));
        poseStack.method_22907(class_7833.field_40715.rotationDegrees(180 - facing.method_10161() * 90));
        class_4588 buffer = bufferIn.getBuffer(class_1921.method_23578(TEXTURE));
        model.renderToBuffer(poseStack, buffer, combinedLightIn, combinedOverlayIn, 1.0F, 1.0F, 1.0F, 1.0F);
        poseStack.method_22909();
    }

    @Override
    public boolean shouldRenderOffScreen(TileEntityKeyboard te) {
        return true;
    }
}
