package com.github.tartaricacid.touhoulittlemaid.client.resource;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.client.animation.gecko.condition.ConditionManager;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.builder.Animation;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.core.molang.MolangParser;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.file.AnimationFile;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.Converter;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.FormatVersion;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.RawGeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.tree.RawGeometryTree;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.GeoBuilder;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built.GeoModel;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.resource.GeckoLibCache;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.json.JsonAnimationUtils;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_2973;
import net.minecraft.class_310;
import net.minecraft.class_3518;

public class GeckoModelLoader {
    public static final class_2960 DEFAULT_MAID_ANIMATION = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "animation/maid.animation.json");
    public static final class_2960 DEFAULT_TAC_ANIMATION = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "animation/tac.animation.json");
    public static final class_2960 DEFAULT_CHAIR_ANIMATION = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "animation/chair.animation.json");
    public static AnimationFile DEFAULT_MAID_ANIMATION_FILE = new AnimationFile();
    public static AnimationFile DEFAULT_CHAIR_ANIMATION_FILE = new AnimationFile();
    public static AnimationFile DEFAULT_TAC_ANIMATION_FILE = new AnimationFile();

    public static void reload() {
        clearAllCache();
        loadDefaultAnimation();
    }

    public static void registerGeo(class_2960 id, InputStream inputStream) {
        Map<class_2960, GeoModel> geoModels = GeckoLibCache.getInstance().getGeoModels();
        RawGeoModel rawModel = Converter.fromInputStream(inputStream);
        if (rawModel.getFormatVersion() == FormatVersion.NEW) {
            RawGeometryTree rawGeometryTree = RawGeometryTree.parseHierarchy(rawModel);
            GeoModel geoModel = GeoBuilder.getGeoBuilder().constructGeoModel(rawGeometryTree);
            geoModels.put(id, geoModel);
        }
    }

    public static void registerMaidAnimations(class_2960 id, AnimationFile animationFile) {
        DEFAULT_MAID_ANIMATION_FILE.animations().forEach((name, action) -> {
            if (!animationFile.animations().containsKey(name)) {
                animationFile.putAnimation(name, action);
            }
        });
        DEFAULT_TAC_ANIMATION_FILE.animations().forEach((name, action) -> {
            if (!animationFile.animations().containsKey(name)) {
                animationFile.putAnimation(name, action);
            }
        });
        animationFile.animations().forEach((name, animation) -> ConditionManager.addTest(id, name));
        GeckoLibCache.getInstance().getAnimations().put(id, animationFile);
    }

    public static void registerChairAnimations(class_2960 id, AnimationFile animationFile) {
        DEFAULT_CHAIR_ANIMATION_FILE.animations().forEach((name, action) -> {
            if (!animationFile.animations().containsKey(name)) {
                animationFile.putAnimation(name, action);
            }
        });
        animationFile.animations().forEach((name, animation) -> ConditionManager.addTest(id, name));
        GeckoLibCache.getInstance().getAnimations().put(id, animationFile);
    }

    public static void mergeAnimationFile(InputStream inputStream, AnimationFile animationFile) {
        mergeAnimationFile(animationFile, getAnimationFile(inputStream));
    }

    private static AnimationFile getAnimationFile(InputStream stream) {
        AnimationFile animationFile = new AnimationFile();
        MolangParser parser = GeckoLibCache.getInstance().parser;
        JsonObject jsonObject = class_3518.method_15276(CustomPackLoader.GSON, new InputStreamReader(stream, StandardCharsets.UTF_8), JsonObject.class);
        for (Map.Entry<String, JsonElement> entry : JsonAnimationUtils.getAnimations(jsonObject)) {
            String animationName = entry.getKey();
            Animation animation;
            try {
                animation = JsonAnimationUtils.deserializeJsonToAnimation(JsonAnimationUtils.getAnimation(jsonObject, animationName), parser);
                animationFile.putAnimation(animationName, animation);
            } catch (class_2973 e) {
                e.printStackTrace();
            }
        }
        return animationFile;
    }

    private static AnimationFile mergeAnimationFile(AnimationFile main, AnimationFile other) {
        other.animations().forEach(main::putAnimation);
        return main;
    }

    private static void clearAllCache() {
        GeckoLibCache.getInstance().getGeoModels().clear();
        // 不能清除动画文件，会导致崩溃
        // GeckoLibCache.getInstance().getAnimations().clear();
    }

    private static void loadDefaultAnimation() {
        try (InputStream stream = class_310.method_1551().method_1478().open(DEFAULT_MAID_ANIMATION)) {
            DEFAULT_MAID_ANIMATION_FILE = getAnimationFile(stream);
        } catch (IOException e) {
            e.printStackTrace();
        }
        try (InputStream stream = class_310.method_1551().method_1478().open(DEFAULT_CHAIR_ANIMATION)) {
            DEFAULT_CHAIR_ANIMATION_FILE = getAnimationFile(stream);
        } catch (IOException e) {
            e.printStackTrace();
        }
        try (InputStream stream = class_310.method_1551().method_1478().open(DEFAULT_TAC_ANIMATION)) {
            DEFAULT_TAC_ANIMATION_FILE = getAnimationFile(stream);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
