package com.github.tartaricacid.touhoulittlemaid.command.subcommand;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.AvailableSites;
import com.github.tartaricacid.touhoulittlemaid.network.message.SyncAiSettingPackage;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

public class AIChatCommand {
    private static final String ROOT_NAME = "ai_chat";
    private static final String RELOAD_NAME = "reload";

    public static LiteralArgumentBuilder<class_2168> get() {
        LiteralArgumentBuilder<class_2168> root = LiteralArgumentBuilder.literal(ROOT_NAME);
        LiteralArgumentBuilder<class_2168> reload = LiteralArgumentBuilder.literal(RELOAD_NAME);
        root.then(reload.executes(AIChatCommand::reload));
        return root;
    }

    private static int reload(CommandContext<class_2168> context) {
        AvailableSites.readSites();
        PlayerLookup.all(context.getSource().method_9211()).forEach(
                player -> ServerPlayNetworking.send(player, SyncAiSettingPackage.getInstance())
        );
        context.getSource().method_9226(() -> class_2561.method_43471("message.touhou_little_maid.ai_chat.reload_success"), true);
        return Command.SINGLE_SUCCESS;
    }
}
