package com.github.tartaricacid.touhoulittlemaid.compat.cloth;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.AvailableSites;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import me.shedaniel.autoconfig.util.Utils;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.DropdownBoxEntry;
import net.minecraft.class_1077;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import java.nio.file.Path;
import java.util.SortedMap;

public class GlobalAIIntegration {
    private static final String DEFAULT_LANGUAGE = "en_us";

    public static void aiChat(ConfigBuilder root, ConfigEntryBuilder entryBuilder) {
        ConfigCategory aiChat = root.getOrCreateCategory(class_2561.method_43471("config.touhou_little_maid.global_ai"));

        aiChat.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("config.touhou_little_maid.global_ai.chat_enable"), AIConfig.CHAT_ENABLED.get())
                .setDefaultValue(true).setTooltip(class_2561.method_43471("config.touhou_little_maid.global_ai.chat_enable.tooltip"))
                .setSaveConsumer(value -> {
                    AIConfig.CHAT_ENABLED.set(value);
                    AIConfig.CHAT_ENABLED.save();
                }).build());

        aiChat.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("config.touhou_little_maid.global_ai.tts_enable"), AIConfig.TTS_ENABLED.get())
                .setDefaultValue(true).setTooltip(class_2561.method_43471("config.touhou_little_maid.global_ai.tts_enable.tooltip"))
                .setSaveConsumer(value -> {
                    AIConfig.TTS_ENABLED.set(value);
                    AIConfig.TTS_ENABLED.save();
                }).build());

        aiChat.addEntry(entryBuilder.startDoubleField(class_2561.method_43471("config.touhou_little_maid.global_ai.chat_temperature"), AIConfig.CHAT_TEMPERATURE.get())
                .setDefaultValue(AIConfig.CHAT_TEMPERATURE.getDefault()).setMin(0.0).setMax(2.0)
                .setTooltip(class_2561.method_43471("config.touhou_little_maid.global_ai.chat_temperature.tooltip"))
                .setSaveConsumer(value -> {
                    AIConfig.CHAT_TEMPERATURE.set(value);
                    AIConfig.CHAT_TEMPERATURE.save();
                }).build());

        aiChat.addEntry(entryBuilder.startIntSlider(class_2561.method_43471("config.touhou_little_maid.global_ai.maid_max_history_chat_size"),
                        AIConfig.MAID_MAX_HISTORY_CHAT_SIZE.get(), 1, 128).setDefaultValue(16)
                .setTooltip(class_2561.method_43471("config.touhou_little_maid.global_ai.maid_max_history_chat_size.tooltip"))
                .setSaveConsumer(value -> {
                    AIConfig.MAID_MAX_HISTORY_CHAT_SIZE.set(value);
                    AIConfig.MAID_MAX_HISTORY_CHAT_SIZE.save();
                }).build());

        SortedMap<String, class_1077> languages = class_310.method_1551().method_1526().method_4665();
        aiChat.addEntry(entryBuilder.startStringDropdownMenu(class_2561.method_43471("config.touhou_little_maid.global_ai.tts_language"),
                        AIConfig.TTS_LANGUAGE.get(), class_2561::method_43470, cell(languages)).setSelections(languages.keySet())
                .setDefaultValue(DEFAULT_LANGUAGE).setTooltip(class_2561.method_43471("config.touhou_little_maid.global_ai.tts_language.tooltip"))
                .setSaveConsumer(info -> {
                    AIConfig.TTS_LANGUAGE.set(info);
                    AIConfig.TTS_LANGUAGE.save();
                }).build());

        Path availableSiteFile = Utils.getConfigFolder().resolve(TouhouLittleMaid.MOD_ID).resolve(AvailableSites.FILE_NAME);
        class_2558 clickEvent = new class_2558(class_2558.class_2559.field_11746, availableSiteFile.toString());
        class_5250 text = class_2561.method_43471("config.touhou_little_maid.global_ai.chat_site.click");
        text.method_27694(s -> s.method_30938(true).method_10977(class_124.field_1078).method_10958(clickEvent));
        aiChat.addEntry(entryBuilder.startTextDescription(text).build());
    }

    private static DropdownBoxEntry.SelectionCellCreator<String> cell(SortedMap<String, class_1077> languages) {
        class_1077 defaultLanguage = languages.get(DEFAULT_LANGUAGE);
        return new DropdownBoxEntry.DefaultSelectionCellCreator<>(i -> languages.getOrDefault(i, defaultLanguage).method_48303());
    }
}
