package com.github.tartaricacid.touhoulittlemaid.datagen;

import com.github.tartaricacid.touhoulittlemaid.datagen.tag.*;
import com.github.tartaricacid.touhoulittlemaid.init.InitDamage;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_7877;
import net.minecraft.class_7924;

public class DataGenerator implements DataGeneratorEntrypoint {
    @Override
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
        // Advancements
        pack.addProvider(AdvancementDataGen::new);

        // Loot Tables
        pack.addProvider(LootTableGenerator.ChestAndAdvancementLootTables::new);
        pack.addProvider(LootTableGenerator.BlockLootTables::new);

        // Global Loot Modifier Fabric使用Event修改
        // pack.addProvider(packOutput -> new GlobalLootModifier(packOutput, registries, TouhouLittleMaid.MOD_ID));

        // Recipe
        pack.addProvider(RecipeGenerator::new);

        // Tags
        pack.addProvider(DamageTypeGenerator::new);
        pack.addProvider(EntityTypeGenerator::new);
        pack.addProvider(TagBlock::new);
        pack.addProvider(TagEnchantment::new);
        pack.addProvider(TagItem::new);
        pack.addProvider(TagRecipeSerializer::new);

        // Registry Based Stuff
        pack.addProvider(RegistryDataGenerator::new);
    }

    @Override
    public void buildRegistry(class_7877 registryBuilder) {
        registryBuilder.method_46777(class_7924.field_41265, EnchantmentKeys::bootstrap);
        registryBuilder.method_46777(class_7924.field_42534, InitDamage::bootstrap);
    }
}
