package com.github.tartaricacid.touhoulittlemaid.datagen;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.block.BlockMaidBed;
import com.github.tartaricacid.touhoulittlemaid.block.BlockScarecrow;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.fabricmc.fabric.api.datagen.v1.provider.SimpleFabricLootTableProvider;
import net.minecraft.class_173;
import net.minecraft.class_1802;
import net.minecraft.class_219;
import net.minecraft.class_2248;
import net.minecraft.class_2742;
import net.minecraft.class_2756;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_7225;
import net.minecraft.class_77;
import net.minecraft.class_7924;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;

public class LootTableGenerator {
    public static final class_5321<class_52> ADDITIONAL_LOOT_TABLE = class_5321.method_29179(class_7924.field_50079, class_2960.method_60655(TouhouLittleMaid.MOD_ID, "chests/additional_loot_table"));
    public static final class_5321<class_52> GIVE_SMART_SLAB = class_5321.method_29179(class_7924.field_50079, class_2960.method_60655(TouhouLittleMaid.MOD_ID, "give_smart_slab"));
    public static final class_5321<class_52> POWER_POINT = class_5321.method_29179(class_7924.field_50079, class_2960.method_60655(TouhouLittleMaid.MOD_ID, "advancement/power_point"));
    public static final class_5321<class_52> CAKE = class_5321.method_29179(class_7924.field_50079, class_2960.method_60655(TouhouLittleMaid.MOD_ID, "advancement/cake"));

    public static class ChestAndAdvancementLootTables extends SimpleFabricLootTableProvider {
        public ChestAndAdvancementLootTables(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(output, registryLookup, class_173.field_1179);
        }

        @Override
        public void method_10399(BiConsumer<class_5321<class_52>, class_52.class_53> consumer) {
            genChestLootTables(consumer);
            genAdvancementsLootTables(consumer);
        }
    }

    private static void genChestLootTables(BiConsumer<class_5321<class_52>, class_52.class_53> consumer) {
        consumer.accept(ADDITIONAL_LOOT_TABLE, class_52.method_324()
                .method_336(class_55.method_347()
                        //.name("power_point")
                        .method_352(class_44.method_32448(1))
                        .method_356(class_219.method_932(0.05F))
                        .method_351(class_77.method_411(InitItems.POWER_POINT)))
                .method_336(class_55.method_347()
                        //.name("shrine")
                        .method_352(class_44.method_32448(1))
                        .method_356(class_219.method_932(0.05F))
                        .method_351(class_77.method_411(InitItems.SHRINE))));
    }

    private static void genAdvancementsLootTables(BiConsumer<class_5321<class_52>, class_52.class_53> consumer) {
        consumer.accept(GIVE_SMART_SLAB, class_52.method_324()
                .method_336(class_55.method_347()
                        .method_352(class_44.method_32448(1))
                        .method_351(class_77.method_411(InitItems.SMART_SLAB_INIT))));

        consumer.accept(POWER_POINT, class_52.method_324().method_336(class_55.method_347()
                .method_352(class_44.method_32448(5))
                .method_351(class_77.method_411(InitItems.POWER_POINT))));

        consumer.accept(CAKE, class_52.method_324().method_336(class_55.method_347()
                .method_352(class_44.method_32448(1))
                .method_351(class_77.method_411(class_1802.field_17534))));
    }

    public static class BlockLootTables extends FabricBlockLootTableProvider {
        public final Set<class_2248> knownBlocks = new HashSet<>();

        protected BlockLootTables(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
            super(dataOutput, registryLookup);
        }


        @Override
        public void method_10379() {
            method_45994(InitBlocks.MAID_BED, block -> method_45987(block, BlockMaidBed.PART, class_2742.field_12560));
            method_45994(InitBlocks.SCARECROW, block -> method_45987(block, BlockScarecrow.HALF, class_2756.field_12607));

            method_46025(InitBlocks.MODEL_SWITCHER);
            method_46025(InitBlocks.KEYBOARD);
            method_46025(InitBlocks.BOOKSHELF);
            method_46025(InitBlocks.COMPUTER);
            method_46025(InitBlocks.SHRINE);
        }

        @Override
        public void method_45988(class_2248 block, class_52.class_53 builder) {
            this.knownBlocks.add(block);
            super.method_45988(block, builder);
        }
    }
}