package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.block.BlockMaidBed;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.github.tartaricacid.touhoulittlemaid.init.InitPoi;
import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2742;
import net.minecraft.class_3218;
import net.minecraft.class_4099;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4215;
import java.util.Comparator;

public class MaidBedTask extends MaidCheckRateTask {
    private final int closeEnoughDist;
    private final float speed;

    public MaidBedTask(float movementSpeed, int closeEnoughDist) {
        super(ImmutableMap.of(class_4140.field_18445, class_4141.field_18457,
                InitEntities.TARGET_POS, class_4141.field_18457));
        this.closeEnoughDist = closeEnoughDist;
        this.speed = movementSpeed;
        this.setMaxCheckRate(10);
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 worldIn, EntityMaid maid) {
        if (super.checkExtraStartConditions(worldIn, maid) && maid.canBrainMoving()) {
            class_2338 bedPos = findBed(worldIn, maid);
            if (bedPos != null && maid.method_18407(bedPos)) {
                if (bedPos.method_19770(maid.method_19538()) < Math.pow(this.closeEnoughDist, 2)) {
                    maid.method_18868().method_18878(InitEntities.TARGET_POS, new class_4099(bedPos));
                    return true;
                }
                class_4215.method_24561(maid, bedPos, speed, 1);
                this.setNextCheckTickCount(5);
            } else {
                maid.method_18868().method_18875(InitEntities.TARGET_POS);
            }
        }
        return false;
    }

    @Override
    protected void start(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        maid.method_18868().method_18904(InitEntities.TARGET_POS).ifPresent(targetPos -> {
            class_2338 pos = targetPos.method_18989();
            class_2680 blockState = worldIn.method_8320(pos);
            if (blockState.method_27852(InitBlocks.MAID_BED) && blockState.method_11654(BlockMaidBed.PART) == class_2742.field_12560 && !blockState.method_11654(class_2244.field_9968)) {
                maid.method_18403(pos);
                maid.method_5814(pos.method_10263() + 0.5, pos.method_10264() + 0.8, pos.method_10260() + 0.5);
            }
        });
        maid.method_18868().method_18875(InitEntities.TARGET_POS);
        maid.method_18868().method_18875(class_4140.field_18445);
        maid.method_18868().method_18875(class_4140.field_18446);
    }

    @Nullable
    private class_2338 findBed(class_3218 world, EntityMaid maid) {
        class_2338 blockPos = maid.getBrainSearchPos();
        class_4153 poiManager = world.method_19494();
        int range = (int) maid.method_18413();
        return poiManager.method_19125(type -> type.comp_349().equals(InitPoi.MAID_BED), blockPos, range, class_4153.class_4155.field_18489)
                .map(class_4156::method_19141).min(Comparator.comparingDouble(pos -> pos.method_10262(maid.method_24515()))).orElse(null);
    }
}
