package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import javax.annotation.Nullable;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4102;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;

public class MaidFollowOwnerTask extends class_4097<EntityMaid> {
    private final float speedModifier;
    private final int stopDistance;

    public MaidFollowOwnerTask(float speedModifier, int stopDistance) {
        super(ImmutableMap.of(class_4140.field_18445, class_4141.field_18458));
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 level, EntityMaid maid) {
        return !maid.getSwimManager().isGoingToBreath();
    }

    @Override
    protected void start(class_3218 worldIn, EntityMaid maid, long gameTimeIn) {
        class_1309 owner = maid.method_35057();
        int startDistance = (int) maid.method_18413() - 2;
        int minTeleportDistance = startDistance + 4;
        if (ownerStateConditions(owner) && maidStateConditions(maid) && !maid.method_24516(owner, startDistance)) {
            if (!maid.method_24516(owner, minTeleportDistance)) {
                maid.teleportToOwner(owner);
                maid.getNavigationManager().resetNavigation();
            } else if (!ownerIsWalkTarget(maid, owner)) {
                class_4215.method_24557(maid, owner, speedModifier, stopDistance);
            }
        }
    }

    private boolean maidStateConditions(EntityMaid maid) {
        return !maid.isHomeModeEnable() && maid.canBrainMoving();
    }

    private boolean ownerStateConditions(@Nullable class_1309 owner) {
        return owner != null && !owner.method_7325() && !owner.method_29504();
    }

    private boolean ownerIsWalkTarget(EntityMaid maid, class_1309 owner) {
        return maid.method_18868().method_18904(class_4140.field_18445).map(target -> {
            if (target.method_19094() instanceof class_4102) {
                return ((class_4102) target.method_19094()).method_35066().equals(owner);
            }
            return false;
        }).orElse(false);
    }
}
