package com.github.tartaricacid.touhoulittlemaid.entity.backpack;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.IMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5599;
import net.minecraft.class_583;
import org.apache.commons.lang3.tuple.Pair;

import java.util.Map;
import java.util.Optional;

public class BackpackManager {
    private static Map<class_2960, IMaidBackpack> BACKPACK_ID_MAP;
    private static Map<class_1792, IMaidBackpack> BACKPACK_ITEM_MAP;
    @Environment(EnvType.CLIENT)
    private static Map<class_2960, Pair<class_583<EntityMaid>, class_2960>> BACKPACK_MODEL_MAP;
    private static IMaidBackpack EMPTY_BACKPACK;

    private BackpackManager() {
        EMPTY_BACKPACK = new EmptyBackpack();
        BACKPACK_ID_MAP = Maps.newHashMap();
        BACKPACK_ITEM_MAP = Maps.newHashMap();
    }

    public static void init() {
        BackpackManager manager = new BackpackManager();
        manager.add(EMPTY_BACKPACK);
        manager.add(new SmallBackpack());
        manager.add(new MiddleBackpack());
        manager.add(new BigBackpack());
        manager.add(new CraftingTableBackpack());
        manager.add(new EnderChestBackpack());
        manager.add(new FurnaceBackpack());
        manager.add(new TankBackpack());
        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            littleMaid.addMaidBackpack(manager);
        }
        BACKPACK_ID_MAP = ImmutableMap.copyOf(BACKPACK_ID_MAP);
        // 将物品和背包绑定
        BACKPACK_ID_MAP.forEach((id, backpack) -> BACKPACK_ITEM_MAP.put(backpack.getItem(), backpack));
        BACKPACK_ITEM_MAP = ImmutableMap.copyOf(BACKPACK_ITEM_MAP);
    }

    @Environment(EnvType.CLIENT)
    public static void initClient(class_5599 modelSet) {
        BACKPACK_MODEL_MAP = Maps.newHashMap();
        BACKPACK_ID_MAP.forEach((id, backpack) -> BACKPACK_MODEL_MAP.put(id, Pair.of(backpack.getBackpackModel(modelSet), backpack.getBackpackTexture())));
        BACKPACK_MODEL_MAP = ImmutableMap.copyOf(BACKPACK_MODEL_MAP);
    }

    public static IMaidBackpack getEmptyBackpack() {
        return EMPTY_BACKPACK;
    }

    public static Optional<IMaidBackpack> findBackpack(class_2960 id) {
        return Optional.ofNullable(BACKPACK_ID_MAP.get(id));
    }

    public static Optional<IMaidBackpack> findBackpack(class_1799 stack) {
        return Optional.ofNullable(BACKPACK_ITEM_MAP.get(stack.method_7909()));
    }

    public static void addBackpackCooldown(class_1657 player) {
        for (class_1792 backpack : BACKPACK_ITEM_MAP.keySet()) {
            player.method_7357().method_7906(backpack, 20);
        }
    }

    @Environment(EnvType.CLIENT)
    public static Optional<Pair<class_583<EntityMaid>, class_2960>> findBackpackModel(class_2960 id) {
        Pair<class_583<EntityMaid>, class_2960> pair = BACKPACK_MODEL_MAP.get(id);
        if (pair == null) {
            return Optional.empty();
        }
        if (pair.getLeft() == null) {
            return Optional.empty();
        }
        return Optional.of(pair);
    }

    public void add(IMaidBackpack backpack) {
        BACKPACK_ID_MAP.put(backpack.getId(), backpack);
    }
}
