package com.github.tartaricacid.touhoulittlemaid.entity.backpack;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.backpack.IMaidBackpack;
import com.github.tartaricacid.touhoulittlemaid.client.model.backpack.EnderChestBackpackModel;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityTombstone;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.backpack.EnderChestBackpackContainer;
import com.github.tartaricacid.touhoulittlemaid.item.BackpackLevel;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_4587;
import net.minecraft.class_5599;
import net.minecraft.class_583;
import javax.annotation.Nullable;

public class EnderChestBackpack extends IMaidBackpack {
    public static final class_2960 ID = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "ender_chest_backpack");

    @Override
    public void onPutOn(class_1799 stack, class_1657 player, EntityMaid maid) {
    }

    @Override
    public void onTakeOff(class_1799 stack, class_1657 player, EntityMaid maid) {
    }

    @Override
    public void onSpawnTombstone(EntityMaid maid, EntityTombstone tombstone) {
    }

    @Override
    public class_3908 getGuiProvider(int entityId) {
        return new ExtendedScreenHandlerFactory<Integer>() {
            @Override
            public Integer getScreenOpeningData(class_3222 player) {
                return entityId;
            }

            @Override
            public class_2561 method_5476() {
                return class_2561.method_43470("Maid Ender Chest Container");
            }

            @Override
            public AbstractMaidContainer createMenu(int index, class_1661 playerInventory, class_1657 player) {
                return new EnderChestBackpackContainer(index, playerInventory, entityId);
            }

            @Override
            public boolean shouldCloseCurrentScreen() {
                return false;
            }

/*            @Override
            public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                return false;
            }*/
        };
    }

    @Override
    public int getAvailableMaxContainerIndex() {
        return BackpackLevel.EMPTY_CAPACITY;
    }

    @Nullable
    @Override
    @Environment(EnvType.CLIENT)
    public class_583<EntityMaid> getBackpackModel(class_5599 modelSet) {
        return new EnderChestBackpackModel(modelSet.method_32072(EnderChestBackpackModel.LAYER));
    }

    @Nullable
    @Override
    @Environment(EnvType.CLIENT)
    public class_2960 getBackpackTexture() {
        return class_2960.method_60655(TouhouLittleMaid.MOD_ID, "textures/entity/ender_chest_backpack.png");
    }

    @Override
    @Environment(EnvType.CLIENT)
    public void offsetBackpackItem(class_4587 poseStack) {
        poseStack.method_22904(0, 0.625, 0.25);
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public class_1792 getItem() {
        return InitItems.ENDER_CHEST_BACKPACK;
    }
}

