package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import io.netty.buffer.ByteBuf;
import org.apache.commons.lang3.StringUtils;

import java.lang.reflect.Type;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.isValidResourceLocation;

public final class ChatText {

    public static final class_2960 EMPTY_ICON_PATH = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "empty");
    public static final ChatText EMPTY_CHAT_TEXT = new ChatText(ChatTextType.EMPTY, EMPTY_ICON_PATH, StringUtils.EMPTY);
    public static final class_9139<ByteBuf, ChatText> STREAM_CODEC = class_9139.method_56436(
            ChatTextType.STREAM_CODEC,
            ChatText::getType,
            class_2960.field_48267,
            ChatText::getIconPath,
            class_9135.field_48554,
            ChatText::getText,
            ChatText::new
    );
    private static final String ICON_IDENTIFIER_CHAR = "%";

    private final ChatTextType type;
    private final class_2960 iconPath;
    private final String text;

    public ChatText(ChatTextType type, class_2960 iconPath, String text) {
        this.type = type;
        this.iconPath = iconPath;
        this.text = text;
    }

    public boolean isText() {
        return type == ChatTextType.TEXT;
    }

    public boolean isIcon() {
        return type == ChatTextType.ICON;
    }

    public class_2960 getIconPath() {
        return iconPath;
    }

    public String getText() {
        return text;
    }

    public ChatTextType getType() {
        return type;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        } else if (!(obj instanceof ChatText chatText)) {
            return false;
        } else {
            return type.equals(chatText.type) && iconPath.equals(chatText.iconPath) && text.equals(chatText.text);
        }
    }

    public static class Serializer implements JsonDeserializer<ChatText> {
        @Override
        public ChatText deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            String text = class_3518.method_15287(json, "chat_text");
            if (StringUtils.isEmpty(text)) {
                return EMPTY_CHAT_TEXT;
            }

            if (text.startsWith(ICON_IDENTIFIER_CHAR) && text.endsWith(ICON_IDENTIFIER_CHAR)) {
                String substring = text.substring(1, text.length() - 1);
                if (isValidResourceLocation(substring)) {
                    return new ChatText(ChatTextType.ICON, class_2960.method_60654(substring), StringUtils.EMPTY);
                }
                return EMPTY_CHAT_TEXT;
            }

            return new ChatText(ChatTextType.TEXT, EMPTY_ICON_PATH, text);
        }
    }
}