package com.github.tartaricacid.touhoulittlemaid.entity.chatbubble;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import org.apache.commons.lang3.StringUtils;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_9262;
import net.minecraft.class_9301;
import net.minecraft.class_9302;
import net.minecraft.class_9334;

public class MaidScriptBookManager {
    private static final String STORE_TAG = "MaidScriptBook";
    private static final String SEPARATOR = "\n\n";

    private final Map<String, List<ChatText>> scripts;

    public MaidScriptBookManager() {
        this.scripts = Maps.newHashMap();
    }

    private static List<String> readBookPages(class_9302 bookContent) {
        return bookContent.method_57525(false).stream().map(class_2561::getString).toList();
    }

    private static List<String> readBookPages(class_9301 bookContent) {
        return bookContent.method_57517(false).toList();
    }

    private static class_9301 replaceBookContentWithPages(final List<String> pages, final class_9301 book) {
        return book.method_58187(pages.stream().map(class_9262::method_57137).toList());
    }

    private static void readScriptsFromPages(final List<String> pages, Map<String, List<ChatText>> scripts) {
        scripts.clear();
        for (var page : pages) {
            String[] split = StringUtils.split(page, SEPARATOR);
            if (split.length < 2) {
                continue;
            }
            String type = StringUtils.strip(split[0]).toLowerCase(Locale.US);
            if (StringUtils.isBlank(type)) {
                continue;
            }
            List<ChatText> scriptList = scripts.computeIfAbsent(type, k -> Lists.newArrayList());
            for (int j = 1; j < split.length; j++) {
                String script = StringUtils.strip(split[j]);
                if (StringUtils.isNotBlank(script)) {
                    ChatText chatText = new ChatText(ChatTextType.TEXT, ChatText.EMPTY_ICON_PATH, script);
                    scriptList.add(chatText);
                }
            }
        }
    }

    private static void writeScriptsToPages(final Map<String, List<ChatText>> scripts, List<String> pages) {
        pages.clear();
        for (Map.Entry<String, List<ChatText>> entry : scripts.entrySet()) {
            String type = entry.getKey();
            List<ChatText> scriptList = entry.getValue();
            if (scriptList.isEmpty()) {
                continue;
            }
            StringBuilder builder = new StringBuilder();
            builder.append(type).append(SEPARATOR);
            for (ChatText chatText : scriptList) {
                builder.append(chatText.getText()).append(SEPARATOR);
            }
            pages.add(builder.toString());
        }
    }

    public boolean installScript(class_1799 stack) {
        class_9302 writtenBookContent = stack.method_57824(class_9334.field_49606);
        if (writtenBookContent != null && !writtenBookContent.method_57525(false).isEmpty()) {
            var pages = readBookPages(writtenBookContent);
            readScriptsFromPages(pages, this.scripts);
            return true;
        }

        class_9301 writableBookContent = stack.method_57824(class_9334.field_49653);
        if (writableBookContent != null && writableBookContent.method_57517(false).findAny().isPresent()) {
            var pages = readBookPages(writableBookContent);
            readScriptsFromPages(pages, this.scripts);
            return true;
        }

        return false;
    }

    public void removeScript() {
        this.scripts.clear();
    }

    public boolean copyScript(class_1799 stack) {
        // 拷贝只能拷贝书与笔，成书不能拷贝
        var book = stack.method_57824(class_9334.field_49653);
        if (book == null || !book.comp_2422().isEmpty()) {
            return false;
        }
        List<String> pages = Lists.newArrayList();
        writeScriptsToPages(this.scripts, pages);
        var newBook = replaceBookContentWithPages(pages, book);
        stack.method_57379(class_9334.field_49653, newBook);
        return true;
    }

    public void addAdditionalSaveData(class_2487 compound) {
        class_2499 scriptsTags = new class_2499();
        List<String> pages = Lists.newArrayList();
        writeScriptsToPages(this.scripts, pages);
        for (String page : pages) {
            scriptsTags.add(class_2519.method_23256(page));
        }
        compound.method_10566(STORE_TAG, scriptsTags);
    }

    public void readAdditionalSaveData(class_2487 compound) {
        if (!compound.method_10573(STORE_TAG, class_2520.field_33259)) {
            return;
        }
        class_2499 scriptsTags = compound.method_10554(STORE_TAG, class_2520.field_33258);
        List<String> pages = Lists.newArrayList();
        for (class_2520 tag : scriptsTags) {
            pages.add(tag.method_10714());
        }
        readScriptsFromPages(pages, this.scripts);
    }

    public List<ChatText> getScripts(String type) {
        return this.scripts.getOrDefault(type, Lists.newArrayList());
    }
}
