package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4048;
import net.minecraft.class_6025;
import net.minecraft.class_7248;
import net.minecraft.world.entity.*;
import javax.annotation.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

import static com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent.OWNER_UUID_TAG_NAME;

public class EntityBroom extends AbstractEntityFromItem implements class_6025, class_7248 {
    public static final class_1299<EntityBroom> TYPE = class_1299.class_1300.<EntityBroom>method_5903(EntityBroom::new, class_1311.field_17715)
            .method_17687(1.375F, 0.5625F)
            .method_27299(10)
            .method_55691(0)
            .method_5905("broom");

    private static final class_2940<Optional<UUID>> OWNER_ID = class_2945.method_12791(EntityBroom.class, class_2943.field_13313);

    private boolean keyForward = false;
    private boolean keyBack = false;
    private boolean keyLeft = false;
    private boolean keyRight = false;

    public EntityBroom(class_1299<EntityBroom> entityType, class_1937 worldIn) {
        super(entityType, worldIn);
        this.method_5875(true);
    }

    public EntityBroom(class_1937 worldIn) {
        this(TYPE, worldIn);
    }

    @Environment(EnvType.CLIENT)
    private static boolean keyForward() {
        return class_310.method_1551().field_1690.field_1894.method_1434();
    }

    @Environment(EnvType.CLIENT)
    private static boolean keyBack() {
        return class_310.method_1551().field_1690.field_1881.method_1434();
    }

    @Environment(EnvType.CLIENT)
    private static boolean keyLeft() {
        return class_310.method_1551().field_1690.field_1913.method_1434();
    }

    @Environment(EnvType.CLIENT)
    private static boolean keyRight() {
        return class_310.method_1551().field_1690.field_1849.method_1434();
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(OWNER_ID, Optional.empty());
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10545(OWNER_UUID_TAG_NAME)) {
            setOwnerUUID(class_2512.method_25930(Objects.requireNonNull(compound.method_10580(OWNER_UUID_TAG_NAME))));
        }
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        this.field_6011.method_12789(OWNER_ID).ifPresent(uuid -> compound.method_25927(OWNER_UUID_TAG_NAME, uuid));
    }

    @Override
    public void method_6091(class_243 vec3) {
        class_1297 entity = this.method_5642();
        if (entity instanceof class_1657 player && this.method_5782() && this.method_5703(e -> e instanceof EntityMaid)) {
            if (field_6002.field_9236) {
                // 不要问我为什么客户端数据能跑到服务端来
                // 一定是玄学
                keyForward = keyForward();
                keyBack = keyBack();
                keyLeft = keyLeft();
                keyRight = keyRight();
            }

            // 按键控制扫帚各个方向速度
            float strafe = keyLeft ? 0.5f : (keyRight ? -0.5f : 0);
            float vertical = keyForward ? -(player.method_36455() - 10) / 22.5f : 0;
            float forward = keyForward ? 3 : (keyBack ? -0.5f : 0);

            this.method_5724(0.02f, new class_243(strafe, vertical, forward));
            this.method_5784(class_1313.field_6308, this.method_18798());
            return;
        }
        if (!this.method_24828()) {
            // 玩家没有坐在扫帚上，那就让它掉下来
            super.method_6091(new class_243(0, -0.3f, 0));
            return;
        }
        super.method_6091(vec3);
    }

    @Override
    protected void method_6070() {
        // 已经坐满两人，不执行
        if (this.method_5685().size() >= 2) {
            return;
        }
        // 已经坐了一人，但不是玩家，不执行
        if (!this.method_5685().isEmpty() && !(this.method_5642() instanceof class_1657)) {
            return;
        }
        if (!field_6002.field_9236) {
            List<EntityMaid> list = field_6002.method_8390(EntityMaid.class, method_5829().method_1012(0.5, 0.1, 0.5), this::canMaidRide);
            list.stream().findFirst().ifPresent(entity -> entity.method_5804(this));
        }
    }

    private boolean canMaidRide(EntityMaid maid) {
        if (maid.canBrainMoving() && !maid.method_5782() && class_1301.method_5911(this).test(maid)) {
            UUID maidOwnerUUID = maid.method_6139();
            UUID broomOwnerUUID = this.method_6139();
            if (maidOwnerUUID == null || broomOwnerUUID == null) {
                return false;
            }
            return maidOwnerUUID.equals(broomOwnerUUID);
        }
        return false;
    }

    @Override
    protected void method_49481(class_1657 player, class_243 pTravelVector) {
        // 记得将 fall distance 设置为 0，否则会摔死
        this.field_6017 = 0;

        // 施加上下晃动
        if (!this.method_24828()) {
            this.method_45319(new class_243(0, 0.01 * Math.sin(this.field_6012 * Math.PI / 18), 0));
        }

        // 与旋转有关系的一堆东西，用来控制扫帚朝向
        this.field_5982 = this.field_6283 = this.field_6241 = this.method_36454();
        this.method_5710(player.method_36454(), player.method_36455());
        super.method_49481(player, pTravelVector);
    }

    @Override
    protected class_243 method_52533(class_1297 passenger, class_4048 dimension, float partialTick) {
        double xOffset = passenger instanceof EntityMaid ? -0.5 : 0;
        if (this.method_5685().size() > 1) {
            if (this.method_5685().indexOf(passenger) == 0) {
                xOffset = 0.35;
            } else {
                xOffset = -0.35;
            }
        }
        class_243 hOffset = new class_243(xOffset, -0.3125, 0).method_1024((float) (-(this.method_36454() + 90) * Math.PI / 180));
        return super.method_52533(passenger, dimension, partialTick).method_1019(hOffset);
    }

    @Override
    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (!player.method_21751() && !this.method_5765() && !(this.method_5642() instanceof class_1657)) {
            if (this.method_5685().size() > 1) {
                return class_1269.method_29236(this.field_6002.field_9236);
            }
            if (!field_6002.field_9236) {
                player.method_5804(this);
            }
            return class_1269.method_29236(this.field_6002.field_9236);
        }
        return super.method_5688(player, hand);
    }

    @Nullable
    @Override
    public class_1309 method_5642() {
        class_1297 entity = this.method_31483();
        if (entity instanceof class_1657 player) {
            return player;
        }
        return null;
    }

    @Override
    public void method_6722(class_1657 player) {
        if (!(player instanceof class_3222 serverPlayer)) {
            return;
        }
        List<class_1297> passengers = this.method_5685();
        boolean hasPlayer = false;
        EntityMaid maidOpen = null;
        for (int i = 0; i < Math.max(passengers.size(), 2); i++) {
            class_1297 entity = passengers.get(i);
            if (entity.equals(player)) {
                hasPlayer = true;
            }
            if (entity instanceof EntityMaid maid && maid.method_6171(player)) {
                maidOpen = maid;
            }
        }
        if (hasPlayer && maidOpen != null) {
            maidOpen.openMaidGui(serverPlayer);
        }
    }

    @Override
    public boolean method_30948() {
        return this.method_5805();
    }

    @Override
    protected boolean method_5818(class_1297 entity) {
        return this.method_5685().size() < 2;
    }

    @Override
    protected boolean canKillEntity(class_1657 player) {
        return true;
    }

    @Override
    protected class_3414 getHitSound() {
        return class_3417.field_14983;
    }

    @Override
    protected class_1792 getWithItem() {
        return InitItems.BROOM;
    }

    @Override
    protected class_1799 getKilledStack() {
        return new class_1799(this.getWithItem());
    }

    @Override
    public boolean method_5747(float pFallDistance, float pMultiplier, class_1282 pSource) {
        return false;
    }

    @Override
    protected void method_5623(double pY, boolean pOnGround, class_2680 pState, class_2338 pPos) {
        this.method_38785();
    }

    @Override
    @Nullable
    public UUID method_6139() {
        return this.field_6011.method_12789(OWNER_ID).orElse(null);
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.field_6011.method_12778(OWNER_ID, Optional.ofNullable(uuid));
    }
}
