package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.task.IFarmTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3610;

public class TaskSugarCane implements IFarmTask {
    private static final class_2960 UID = class_2960.method_60655(TouhouLittleMaid.MOD_ID, "sugar_cane");

    @Override
    public class_2960 getUid() {
        return UID;
    }

    @Override
    public class_1799 getIcon() {
        return class_1802.field_17531.method_7854();
    }

    @Override
    public boolean isSeed(class_1799 stack) {
        return stack.method_7909() == class_1802.field_17531;
    }

    @Override
    public boolean canHarvest(EntityMaid maid, class_2338 cropPos, class_2680 cropState) {
        class_2680 blockDownState = maid.field_6002.method_8320(cropPos.method_10074());
        class_2680 blockDown2State = maid.field_6002.method_8320(cropPos.method_10087(2));
        return cropState.method_27852(class_2246.field_10424) && blockDownState.method_27852(class_2246.field_10424) && canSustainSugarCane(blockDown2State);
    }

    @Override
    public void harvest(EntityMaid maid, class_2338 cropPos, class_2680 cropState) {
        maid.destroyBlock(cropPos);
    }

    @Override
    public boolean canPlant(EntityMaid maid, class_2338 basePos, class_2680 baseState, class_1799 seed) {
        class_1937 world = maid.method_37908();
        class_2338 cropPos = basePos.method_10084();
        if (!world.method_8320(cropPos).method_45474() || world.method_8320(cropPos).method_51176()) {
            return false;
        }
        return canSustainSugarCane(baseState) && hasWaterSourceBlock(maid.field_6002, basePos);
    }

    @Override
    public class_1799 plant(EntityMaid maid, class_2338 basePos, class_2680 baseState, class_1799 seed) {
        if (seed.method_7909() == class_1802.field_17531) {
            maid.placeItemBlock(basePos.method_10084(), seed);
        }
        return seed;
    }

    @Override
    public double getCloseEnoughDist() {
        return 2.0;
    }

    private boolean canSustainSugarCane(class_2680 state) {
        return state.method_26164(class_3481.field_29822) || state.method_26164(class_3481.field_15466);
    }

    private boolean hasWaterSourceBlock(class_1937 world, class_2338 basePos) {
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2680 offsetState = world.method_8320(basePos.method_10093(direction));
            class_3610 fluidState = world.method_8316(basePos.method_10093(direction));
            if (fluidState.method_15767(class_3486.field_15517) || offsetState.method_27852(class_2246.field_10110)) {
                return true;
            }
        }
        return false;
    }
}
