package com.github.tartaricacid.touhoulittlemaid.init;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.block.BlockGarageKit;
import com.github.tartaricacid.touhoulittlemaid.datagen.EnchantmentKeys;
import com.github.tartaricacid.touhoulittlemaid.item.ItemChair;
import com.github.tartaricacid.touhoulittlemaid.item.ItemEntityPlaceholder;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1761;
import net.minecraft.class_1772;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import vazkii.patchouli.common.item.ItemModBook;

import java.util.Optional;

import static com.github.tartaricacid.touhoulittlemaid.init.InitItems.*;

public class InitCreativeTabs {
    public static void init() {

    }

    public static class_1761 MAIN_TAB = register("main", FabricItemGroup.builder()
            .method_47321(class_2561.method_43471("item_group.touhou_little_maid.main"))
            .method_47320(() -> InitItems.HAKUREI_GOHEI.method_7854())
            .method_47317((par, output) -> {
                if (FabricLoader.getInstance().isModLoaded("patchouli")) {
                    output.method_45420(ItemModBook.forBook(MEMORIZABLE_GENSOKYO_LOCATION));
                }
                output.method_45421(MAID_SPAWN_EGG);
                output.method_45421(FAIRY_SPAWN_EGG);
                output.method_45421(HAKUREI_GOHEI);
                output.method_45421(SANAE_GOHEI);
                output.method_45421(POWER_POINT);
                output.method_45421(SMART_SLAB_EMPTY);
                output.method_45421(SMART_SLAB_INIT);
                output.method_45421(MAID_BACKPACK_SMALL);
                output.method_45421(MAID_BACKPACK_MIDDLE);
                output.method_45421(MAID_BACKPACK_BIG);
                output.method_45421(CRAFTING_TABLE_BACKPACK);
                output.method_45421(ENDER_CHEST_BACKPACK);
                output.method_45421(FURNACE_BACKPACK);
                output.method_45421(TANK_BACKPACK);
                output.method_45421(SUBSTITUTE_JIZO);
                output.method_45421(ULTRAMARINE_ORB_ELIXIR);
                output.method_45421(EXPLOSION_PROTECT_BAUBLE);
                output.method_45421(FIRE_PROTECT_BAUBLE);
                output.method_45421(PROJECTILE_PROTECT_BAUBLE);
                output.method_45421(MAGIC_PROTECT_BAUBLE);
                output.method_45421(FALL_PROTECT_BAUBLE);
                output.method_45421(DROWN_PROTECT_BAUBLE);
                output.method_45421(NIMBLE_FABRIC);
                output.method_45421(ITEM_MAGNET_BAUBLE);
                output.method_45421(MUTE_BAUBLE);
                output.method_45421(WIRELESS_IO);
                output.method_45421(TRUMPET);
                output.method_45421(RED_FOX_SCROLL);
                output.method_45421(WHITE_FOX_SCROLL);
                output.method_45421(SERVANT_BELL);
                output.method_45421(KAPPA_COMPASS);
                output.method_45421(EXTINGUISHER);
                output.method_45421(GOMOKU);
                output.method_45421(CCHESS);
                output.method_45421(WCHESS);
                output.method_45421(KEYBOARD);
                output.method_45421(BOOKSHELF);
                output.method_45421(COMPUTER);
                output.method_45421(FAVORABILITY_TOOL_ADD);
                output.method_45421(FAVORABILITY_TOOL_REDUCE);
                output.method_45421(FAVORABILITY_TOOL_FULL);
                output.method_45421(CAMERA);
                output.method_45421(PHOTO);
                output.method_45421(FILM);
                output.method_45421(CHISEL);
                output.method_45421(MAID_BED);
                output.method_45421(PICNIC_BASKET);
                output.method_45421(MAID_BEACON);
                output.method_45421(SHRINE);
                output.method_45421(MODEL_SWITCHER);
                output.method_45421(CHAIR_SHOW);
                output.method_45421(BROOM);
                output.method_45421(SCARECROW);
                output.method_45421(ENTITY_ID_COPY);
                if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                    ItemEntityPlaceholder.fillItemCategory(output);
                }
                par.comp_1253().method_46759(class_7924.field_41265).ifPresent(reg -> {
                    addEnchantmentBook(reg.method_46746(EnchantmentKeys.IMPEDING), output);
                    addEnchantmentBook(reg.method_46746(EnchantmentKeys.SPEEDY), output);
                    addEnchantmentBook(reg.method_46746(EnchantmentKeys.ENDERS_ENDER), output);
                });
            }).method_47324());

    public static class_1761 GARAGE_KIT_TAB = register("chair", FabricItemGroup.builder()
            .method_47321(class_2561.method_43471("item_group.touhou_little_maid.chair"))
            .method_47320(() -> InitItems.CHAIR.method_7854())
            .method_47317((par, output) -> {
                if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                    ItemChair.fillItemCategory(output);
                }
            }).method_47324());

    public static class_1761 CHAIR_TAB = register("garage_kit", FabricItemGroup.builder()
            .method_47321(class_2561.method_43471("item_group.touhou_little_maid.garage_kit"))
            .method_47320(() -> InitItems.GARAGE_KIT.method_7854())
            .method_47317((par, output) -> {
                if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                    BlockGarageKit.fillItemCategory(output);
                }
            }).method_47324());

    private static void addEnchantmentBook(Optional<class_6880.class_6883<class_1887>> holder, class_1761.class_7704 output) {
        holder.ifPresent(ref -> {
            class_1889 instance = new class_1889(ref, ref.comp_349().method_8183());
            output.method_45420(class_1772.method_7808(instance));
        });
    }

    private static class_1761 register(String id, class_1761 tab) {
        return class_2378.method_10230(class_7923.field_44687, class_2960.method_60655(TouhouLittleMaid.MOD_ID, id), tab);
    }
}
