package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1322;
import net.minecraft.class_1765;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5134;
import net.minecraft.class_7225;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import javax.annotation.Nullable;
import java.text.DecimalFormat;
import java.util.List;

import static com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent.STORAGE_DATA_TAG;

public class ItemMaidBeacon extends class_1765 {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    private static final String NEO_FORGE_DATA_TAG = "NeoForgeData";

    public ItemMaidBeacon() {
        super(InitBlocks.MAID_BEACON, (new class_1792.class_1793())
                .method_7889(1)
                .method_57348(class_9285.method_57480()
                        .method_57487(class_5134.field_23721, new class_1322(field_8006, 3, class_1322.class_1323.field_6328), class_9274.field_49217)
                        .method_57487(class_5134.field_23723, new class_1322(field_8001, -3.2F, class_1322.class_1323.field_6328), class_9274.field_49217)
                        .method_57486()));
    }

    public static class_1799 tileEntityToItemStack(class_7225.class_7874 provider, TileEntityMaidBeacon beacon) {
        class_1799 stack = InitItems.MAID_BEACON.method_7854();
        stack.method_57379(STORAGE_DATA_TAG, beacon.method_38244(provider));
        return stack;
    }

    public static void itemStackToTileEntity(class_1799 stack, TileEntityMaidBeacon beacon) {
        class_2487 tag = stack.method_57824(STORAGE_DATA_TAG);
        if (tag != null) {
            beacon.loadData(tag);
        }
    }

    @Override
    @Environment(EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1792.class_9635 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        float numPower = 0f;
        class_2487 tag = stack.method_57824(STORAGE_DATA_TAG);
        if (tag != null && tag.method_10573(NEO_FORGE_DATA_TAG, class_2520.field_33260)) {
            class_2487 forgeTag = tag.method_10562(NEO_FORGE_DATA_TAG);
            if (forgeTag.method_10573(TileEntityMaidBeacon.STORAGE_POWER_TAG, class_2520.field_33255)) {
                numPower = forgeTag.method_10583(TileEntityMaidBeacon.STORAGE_POWER_TAG);
            }
        }
        tooltip.add(class_2561.method_43469("tooltips.touhou_little_maid.maid_beacon.desc", DECIMAL_FORMAT.format(numPower)).method_27692(class_124.field_1080));
    }
}
