package com.github.tartaricacid.touhoulittlemaid.loot;

import cn.sh1rocu.touhoulittlemaid.api.extension.ILootTable;
import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitLootCondition;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_5342;
import org.jetbrains.annotations.NotNull;

public record LootTableTypeCondition(String prefix) implements class_5341 {
    public static final MapCodec<LootTableTypeCondition> CODEC = RecordCodecBuilder.mapCodec(inst ->
            inst.group(Codec.STRING.fieldOf("loot_table_type").forGetter(LootTableTypeCondition::prefix))
                    .apply(inst, LootTableTypeCondition::new));

    @Override
    public boolean test(class_47 context) {
        class_2960 lootTableId = ((ILootTable) context).tlm$getQueriedLootTableId();
        return lootTableId.method_12832().startsWith(prefix) && !lootTableId.method_12836().equals(TouhouLittleMaid.MOD_ID);
    }

    @Override
    public @NotNull class_5342 method_29325() {
        return InitLootCondition.LOOT_TABLE_TYPE;
    }
}