package com.github.tartaricacid.touhoulittlemaid.mixin;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_5568;
import net.minecraft.class_5572;
import net.minecraft.class_5573;
import net.minecraft.class_5579;
import net.minecraft.class_5584;
import net.minecraft.world.level.entity.*;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.List;

/**
 * 当马上要从世界卸载时，传送到玩家身边，用来避免女仆在卸载区块上
 * <p>
 * 参考自：<a href="https://github.com/Snownee/Companion/blob/1.20-forge/src/main/java/snownee/companion/mixin/PersistentEntitySectionManagerMixin.java">companion</a>
 */
@Mixin(class_5579.class)
public abstract class PersistentEntitySectionManagerMixin {
    @Final
    @Shadow
    private LongSet chunksToUnload;
    @Final
    @Shadow
    private Long2ObjectMap<class_5584> chunkVisibility;
    @Final
    @Shadow
    class_5573<class_5568> sectionStorage;

    @Inject(
            at = @At(
                    value = "INVOKE", target = "Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;processUnloads()V"
            ), method = "tick"
    )
    private void companionTick(CallbackInfo ci) {
        chunksToUnload.forEach(l -> {
            if (this.chunkVisibility.get(l) != class_5584.field_27289 || !areEntitiesLoaded(l)) {
                return;
            }
            List<class_5568> entities = sectionStorage.method_31782(l).flatMap(class_5572::method_31766).toList();
            handleChunkPreUnload(entities);
        });
    }

    @Unique
    private static void handleChunkPreUnload(List<class_5568> entities) {
        for (var entityAccess : entities) {
            if (entityAccess instanceof EntityMaid maid && maid.method_35057() instanceof class_1657 owner) {
                // 跨维度就不能传送了
                if (owner.method_37908() != maid.method_37908()) {
                    continue;
                }
                if (!shouldFollowOwner(owner, maid)) {
                    continue;
                }
                if (maid.teleportToOwner(owner)) {
                    MaidWorldData data = MaidWorldData.get(maid.field_6002);
                    if (data != null) {
                        data.removeInfo(maid);
                    }
                }
            }
        }
    }

    @Unique
    private static boolean shouldFollowOwner(class_1309 owner, EntityMaid maid) {
        if (owner == null || owner.method_29504() || owner.method_7325()) {
            return false;
        }
        return !maid.isHomeModeEnable() && maid.canBrainMoving();
    }

    @Shadow
    public abstract boolean areEntitiesLoaded(long l);
}
