package com.github.tartaricacid.touhoulittlemaid.network;

import cn.sh1rocu.touhoulittlemaid.util.forge.network.AdvancedAddEntityPayload;
import com.github.tartaricacid.touhoulittlemaid.network.message.*;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class NetworkHandler {
    public static void registerPackets() {
        registerC2SPackets();
        registerS2CPackets();
    }

    private static <T extends class_8710> void registerC2SPacket(class_8710.class_9154<T> type, class_9139<? super class_9129, T> streamCodec, ServerPlayNetworking.PlayPayloadHandler<T> handler) {
        PayloadTypeRegistry.playC2S().register(type, streamCodec);
        ServerPlayNetworking.registerGlobalReceiver(type, handler);
    }

    private static <T extends class_8710> void registerS2CPacket(class_8710.class_9154<T> type, class_9139<? super class_9129, T> streamCodec) {
        PayloadTypeRegistry.playS2C().register(type, streamCodec);
    }

    @Environment(EnvType.CLIENT)
    public static <T extends class_8710> void registerClientReceivers() {
        ClientPlayNetworking.registerGlobalReceiver(OpenChairGuiPackage.TYPE, OpenChairGuiPackage::handle);
        ClientPlayNetworking.registerGlobalReceiver(ItemBreakPackage.TYPE, ItemBreakPackage::handle);
        ClientPlayNetworking.registerGlobalReceiver(SpawnParticlePackage.TYPE, SpawnParticlePackage::handle);
        ClientPlayNetworking.registerGlobalReceiver(SyncDataPackage.TYPE, SyncDataPackage::handle);
        ClientPlayNetworking.registerGlobalReceiver(OpenBeaconGuiPackage.TYPE, OpenBeaconGuiPackage::handle);
        ClientPlayNetworking.registerGlobalReceiver(BeaconAbsorbPackage.TYPE, BeaconAbsorbPackage::handle);
        ClientPlayNetworking.registerGlobalReceiver(OpenSwitcherGuiPackage.TYPE, OpenSwitcherGuiPackage::handle);
        ClientPlayNetworking.registerGlobalReceiver(SendEffectPackage.TYPE, SendEffectPackage::handle);
        ClientPlayNetworking.registerGlobalReceiver(PlayMaidSoundPackage.TYPE, PlayMaidSoundPackage::handle);
        ClientPlayNetworking.registerGlobalReceiver(GomokuClientPackage.TYPE, GomokuClientPackage::handle);
        ClientPlayNetworking.registerGlobalReceiver(FoxScrollPackage.TYPE, FoxScrollPackage::handle);
        ClientPlayNetworking.registerGlobalReceiver(CheckSchedulePosPacket.TYPE, CheckSchedulePosPacket::handle);
        ClientPlayNetworking.registerGlobalReceiver(SyncMaidAreaPackage.TYPE, SyncMaidAreaPackage::handle);
        ClientPlayNetworking.registerGlobalReceiver(CChessToClientPackage.TYPE, CChessToClientPackage::handle);
        ClientPlayNetworking.registerGlobalReceiver(WChessToClientPackage.TYPE, WChessToClientPackage::handle);
        ClientPlayNetworking.registerGlobalReceiver(TTSAudioToClientPackage.TYPE, TTSAudioToClientPackage::handle);
        ClientPlayNetworking.registerGlobalReceiver(SyncAiSettingPackage.TYPE, SyncAiSettingPackage::handle);
        ClientPlayNetworking.registerGlobalReceiver(OpenMaidAIDataScreenPackage.TYPE, OpenMaidAIDataScreenPackage::handle);
        // 仅安装 YSM 后才会发送此包
        ClientPlayNetworking.registerGlobalReceiver(SyncYsmMaidDataPackage.TYPE, SyncYsmMaidDataPackage::handle);
        ClientPlayNetworking.registerGlobalReceiver(TTSSystemAudioToClientPackage.TYPE, TTSSystemAudioToClientPackage::handle);

        ClientPlayNetworking.registerGlobalReceiver(AdvancedAddEntityPayload.TYPE, AdvancedAddEntityPayload::handle);

        ClientPlayNetworking.registerGlobalReceiver(SyncFluidAmountPackage.TYPE, SyncFluidAmountPackage::handle);

    }

    public static void registerS2CPackets() {
        registerS2CPacket(OpenChairGuiPackage.TYPE, OpenChairGuiPackage.STREAM_CODEC);
        registerS2CPacket(ItemBreakPackage.TYPE, ItemBreakPackage.STREAM_CODEC);
        registerS2CPacket(SpawnParticlePackage.TYPE, SpawnParticlePackage.STREAM_CODEC);
        registerS2CPacket(SyncDataPackage.TYPE, SyncDataPackage.STREAM_CODEC);
        registerS2CPacket(OpenBeaconGuiPackage.TYPE, OpenBeaconGuiPackage.STREAM_CODEC);
        registerS2CPacket(BeaconAbsorbPackage.TYPE, BeaconAbsorbPackage.STREAM_CODEC);
        registerS2CPacket(OpenSwitcherGuiPackage.TYPE, OpenSwitcherGuiPackage.STREAM_CODEC);
        registerS2CPacket(SendEffectPackage.TYPE, SendEffectPackage.STREAM_CODEC);
        registerS2CPacket(PlayMaidSoundPackage.TYPE, PlayMaidSoundPackage.STREAM_CODEC);
        registerS2CPacket(GomokuClientPackage.TYPE, GomokuClientPackage.STREAM_CODEC);
        registerS2CPacket(FoxScrollPackage.TYPE, FoxScrollPackage.STREAM_CODEC);
        registerS2CPacket(CheckSchedulePosPacket.TYPE, CheckSchedulePosPacket.STREAM_CODEC);
        registerS2CPacket(SyncMaidAreaPackage.TYPE, SyncMaidAreaPackage.STREAM_CODEC);
        registerS2CPacket(CChessToClientPackage.TYPE, CChessToClientPackage.STREAM_CODEC);
        registerS2CPacket(WChessToClientPackage.TYPE, WChessToClientPackage.STREAM_CODEC);
        registerS2CPacket(TTSAudioToClientPackage.TYPE, TTSAudioToClientPackage.STREAM_CODEC);
        registerS2CPacket(SyncAiSettingPackage.TYPE, SyncAiSettingPackage.STREAM_CODEC);
        registerS2CPacket(OpenMaidAIDataScreenPackage.TYPE, OpenMaidAIDataScreenPackage.STREAM_CODEC);
        // 仅安装 YSM 后才会发送此包
        registerS2CPacket(SyncYsmMaidDataPackage.TYPE, SyncYsmMaidDataPackage.STREAM_CODEC);
        registerS2CPacket(TTSSystemAudioToClientPackage.TYPE, TTSSystemAudioToClientPackage.STREAM_CODEC);

        registerS2CPacket(AdvancedAddEntityPayload.TYPE, AdvancedAddEntityPayload.STREAM_CODEC);

        registerS2CPacket(SyncFluidAmountPackage.TYPE, SyncFluidAmountPackage.STREAM_CODEC);
    }

    public static void registerC2SPackets() {
        registerC2SPacket(MaidModelPackage.TYPE, MaidModelPackage.STREAM_CODEC, MaidModelPackage::handle);
        registerC2SPacket(ChairModelPackage.TYPE, ChairModelPackage.STREAM_CODEC, ChairModelPackage::handle);
        registerC2SPacket(MaidConfigPackage.TYPE, MaidConfigPackage.STREAM_CODEC, MaidConfigPackage::handle);
        registerC2SPacket(MaidTaskPackage.TYPE, MaidTaskPackage.STREAM_CODEC, MaidTaskPackage::handle);
        registerC2SPacket(SendNameTagPackage.TYPE, SendNameTagPackage.STREAM_CODEC, SendNameTagPackage::handle);
        registerC2SPacket(WirelessIOGuiPackage.TYPE, WirelessIOGuiPackage.STREAM_CODEC, WirelessIOGuiPackage::handle);
        registerC2SPacket(WirelessIOSlotConfigPackage.TYPE, WirelessIOSlotConfigPackage.STREAM_CODEC, WirelessIOSlotConfigPackage::handle);
        registerC2SPacket(SetBeaconPotionPackage.TYPE, SetBeaconPotionPackage.STREAM_CODEC, SetBeaconPotionPackage::handle);
        registerC2SPacket(StorageAndTakePowerPackage.TYPE, StorageAndTakePowerPackage.STREAM_CODEC, StorageAndTakePowerPackage::handle);
        registerC2SPacket(SetBeaconOverflowPackage.TYPE, SetBeaconOverflowPackage.STREAM_CODEC, SetBeaconOverflowPackage::handle);
        registerC2SPacket(SaveSwitcherDataPackage.TYPE, SaveSwitcherDataPackage.STREAM_CODEC, SaveSwitcherDataPackage::handle);
        registerC2SPacket(ToggleTabPackage.TYPE, ToggleTabPackage.STREAM_CODEC, ToggleTabPackage::handle);
        registerC2SPacket(RequestEffectPackage.TYPE, RequestEffectPackage.STREAM_CODEC, RequestEffectPackage::handle);
        registerC2SPacket(SetMaidSoundIdPackage.TYPE, SetMaidSoundIdPackage.STREAM_CODEC, SetMaidSoundIdPackage::handle);
        registerC2SPacket(GomokuServerPackage.TYPE, GomokuServerPackage.STREAM_CODEC, GomokuServerPackage::handle);
        registerC2SPacket(SetScrollPackage.TYPE, SetScrollPackage.STREAM_CODEC, SetScrollPackage::handle);
        registerC2SPacket(ServantBellSetPackage.TYPE, ServantBellSetPackage.STREAM_CODEC, ServantBellSetPackage::handle);
        registerC2SPacket(SetAttackListPackage.TYPE, SetAttackListPackage.STREAM_CODEC, SetAttackListPackage::handle);
        registerC2SPacket(RefreshMaidBrainPackage.TYPE, RefreshMaidBrainPackage.STREAM_CODEC, RefreshMaidBrainPackage::handle);
        registerC2SPacket(MaidSubConfigPackage.TYPE, MaidSubConfigPackage.STREAM_CODEC, MaidSubConfigPackage::handle);
        registerC2SPacket(CChessToServerPackage.TYPE, CChessToServerPackage.STREAM_CODEC, CChessToServerPackage::handle);
        registerC2SPacket(WChessToServerPackage.TYPE, WChessToServerPackage.STREAM_CODEC, WChessToServerPackage::handle);
        registerC2SPacket(SendUserChatPackage.TYPE, SendUserChatPackage.STREAM_CODEC, SendUserChatPackage::handle);
        // 仅安装 YSM 后才会发送此包
        registerC2SPacket(YsmMaidModelPackage.TYPE, YsmMaidModelPackage.STREAM_CODEC, YsmMaidModelPackage::handle);
        registerC2SPacket(SaveMaidAIDataPackage.TYPE, SaveMaidAIDataPackage.STREAM_CODEC, SaveMaidAIDataPackage::handle);
        registerC2SPacket(GetMaidAIDataPackage.TYPE, GetMaidAIDataPackage.STREAM_CODEC, GetMaidAIDataPackage::handle);

    }

    public static void sendToNearby(class_1297 entity, class_8710 toSend) {
        if (entity.field_6002 instanceof class_3218) {
            for (class_3222 target : PlayerLookup.tracking(entity)) {
                ServerPlayNetworking.send(target, toSend);
            }
        }
    }

    public static void sendToNearby(class_1297 entity, class_8710 toSend, int distance) {
        if (entity.field_6002 instanceof class_3218 serverLevel) {
            class_2338 pos = entity.method_24515();
            for (class_3222 target : PlayerLookup.around(serverLevel, new class_2382(pos.method_10263(), pos.method_10264(), pos.method_10260()), distance)) {
                ServerPlayNetworking.send(target, toSend);
            }
        }
    }
}
