package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record GetMaidAIDataPackage(int entityId) implements class_8710 {
    public static final class_8710.class_9154<GetMaidAIDataPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("get_maid_ai_data"));
    public static final class_9139<class_9129, GetMaidAIDataPackage> STREAM_CODEC = class_9139.method_56434(
            class_9135.field_48550,
            GetMaidAIDataPackage::entityId,
            GetMaidAIDataPackage::new
    );

    public static void handle(GetMaidAIDataPackage message, ServerPlayNetworking.Context context) {
        context.server().execute(() -> handleInner(message, context));
    }

    private static void handleInner(GetMaidAIDataPackage message, ServerPlayNetworking.Context context) {
        class_3222 sender = context.player();
        class_1297 entity = sender.field_6002.method_8469(message.entityId);
        if (entity instanceof EntityMaid maid && maid.method_6171(sender)) {
            ServerPlayNetworking.send(sender, new OpenMaidAIDataScreenPackage(message.entityId, maid.getAiChatManager()));
        }
    }

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}
