package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.TriggerType;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.TabIndex;
import com.github.tartaricacid.touhoulittlemaid.entity.task.TaskManager;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.task.TaskConfigContainer;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record MaidTaskPackage(int id, class_2960 uid) implements class_8710 {
    public static final class_8710.class_9154<MaidTaskPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("maid_task"));
    public static final class_9139<ByteBuf, MaidTaskPackage> STREAM_CODEC = class_9139.method_56435(
            class_9135.field_48550,
            MaidTaskPackage::id,
            class_2960.field_48267,
            MaidTaskPackage::uid,
            MaidTaskPackage::new
    );

    @Override
    public class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void handle(MaidTaskPackage message, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 sender = context.player();
            class_1297 entity = sender.field_6002.method_8469(message.id);
            if (entity instanceof EntityMaid maid && maid.method_6171(sender)) {
                IMaidTask task = TaskManager.findTask(message.uid).orElse(TaskManager.getIdleTask());
                if (!task.isEnable(maid)) {
                    return;
                }
                maid.setTask(task);
                if (!TaskManager.getIdleTask().equals(task) && maid.method_35057() instanceof class_3222 serverPlayer) {
                    InitTrigger.MAID_EVENT.trigger(serverPlayer, TriggerType.SWITCH_TASK);
                }
                // 如果此时玩家打开的是配置界面
                if (sender.field_7512 instanceof TaskConfigContainer) {
                    maid.openMaidGui(sender, TabIndex.TASK_CONFIG);
                }
            }
        });
    }
}
