package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIDataSerializable;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.ai.AIChatScreen;
import com.github.tartaricacid.touhoulittlemaid.compat.cloth.ClothConfigCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.registry.CompatRegistry;
import io.netty.buffer.ByteBuf;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record OpenMaidAIDataScreenPackage(int entityId, MaidAIDataSerializable data) implements class_8710 {
    public static final class_8710.class_9154<OpenMaidAIDataScreenPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("open_maid_ai_data_screen"));
    public static final class_9139<ByteBuf, OpenMaidAIDataScreenPackage> STREAM_CODEC = class_9139.method_56435(
            class_9135.field_48550,
            OpenMaidAIDataScreenPackage::entityId,
            MaidAIDataSerializable.STREAM_CODEC,
            OpenMaidAIDataScreenPackage::data,
            OpenMaidAIDataScreenPackage::new
    );

    @Override
    public @NotNull class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void handle(OpenMaidAIDataScreenPackage message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> handle(message));
    }

    @Environment(EnvType.CLIENT)
    private static void handle(OpenMaidAIDataScreenPackage message) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return;
        }
        class_1297 e = mc.field_1687.method_8469(message.entityId);
        if (e instanceof EntityMaid maid && maid.method_5805()) {
            maid.getAiChatManager().copyFrom(message.data);
            openConfigScreen(maid, mc);
        }
    }

    @Environment(EnvType.CLIENT)
    private static void openConfigScreen(EntityMaid maid, class_310 mc) {
        if (mc.field_1755 instanceof AIChatScreen) {
            if (FabricLoader.getInstance().isModLoaded(CompatRegistry.CLOTH_CONFIG)) {
                ClothConfigCompat.openPartAiSettingScreen(maid);
            } else if (mc.field_1724 != null) {
                mc.field_1724.method_43496(class_2561.method_43471("gui.touhou_little_maid.cloth_config_warning.tips").method_27692(class_124.field_1061));
            }
        }
    }
}
