package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIDataSerializable;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record SaveMaidAIDataPackage(int entityId, MaidAIDataSerializable data) implements class_8710 {
    public static final class_8710.class_9154<SaveMaidAIDataPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("save_maid_ai_data"));
    public static final class_9139<ByteBuf, SaveMaidAIDataPackage> STREAM_CODEC = class_9139.method_56435(
            class_9135.field_48550,
            SaveMaidAIDataPackage::entityId,
            MaidAIDataSerializable.STREAM_CODEC,
            SaveMaidAIDataPackage::data,
            SaveMaidAIDataPackage::new
    );

    @Override
    public @NotNull class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void handle(SaveMaidAIDataPackage message, ServerPlayNetworking.Context context) {
        context.server().execute(() -> handle(message, context.player()));
    }

    private static void handle(SaveMaidAIDataPackage message, @Nullable class_3222 player) {
        if (player == null) {
            return;
        }
        class_1297 entity = player.field_6002.method_8469(message.entityId);
        if (entity instanceof EntityMaid maid && maid.method_6171(player)) {
            maid.getAiChatManager().copyFrom(message.data);
        }
    }
}
