package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.AvailableSites;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.SettingReader;
import com.github.tartaricacid.touhoulittlemaid.client.event.PressAIChatKeyEvent;
import com.github.tartaricacid.touhoulittlemaid.client.gui.entity.maid.ai.AIChatScreen;
import com.github.tartaricacid.touhoulittlemaid.util.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import java.util.List;
import java.util.Map;
import java.util.Set;

import static com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil.getResourceLocation;

public record SyncAiSettingPackage(Set<String> settings, Map<String, List<String>> chatSites,
                                   Map<String, List<String>> ttsSites) implements class_8710 {
    public static final class_8710.class_9154<SyncAiSettingPackage> TYPE = new class_8710.class_9154<>(getResourceLocation("send_ai_setting"));
    public static final class_9139<ByteBuf, SyncAiSettingPackage> STREAM_CODEC = class_9139.method_56436(
            ByteBufUtils.STRING_SET_CODEC,
            SyncAiSettingPackage::settings,
            ByteBufUtils.SITES_CODEC,
            SyncAiSettingPackage::chatSites,
            ByteBufUtils.SITES_CODEC,
            SyncAiSettingPackage::ttsSites,
            SyncAiSettingPackage::new
    );

    public static SyncAiSettingPackage getInstance() {
        return new SyncAiSettingPackage(SettingReader.getAllSettingKeys(),
                AvailableSites.getClientChatSites(),
                AvailableSites.getClientTtsSites());
    }

    @Override
    public @NotNull class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void handle(SyncAiSettingPackage message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> handle(message));
    }

    @Environment(EnvType.CLIENT)
    private static void handle(SyncAiSettingPackage message) {
        PressAIChatKeyEvent.CAN_CHAT_MAID_IDS.clear();
        PressAIChatKeyEvent.CAN_CHAT_MAID_IDS.addAll(message.settings);
        AIChatScreen.CLIENT_CHAT_SITES.clear();
        AIChatScreen.CLIENT_CHAT_SITES.putAll(message.chatSites);
        AIChatScreen.CLIENT_TTS_SITES.clear();
        AIChatScreen.CLIENT_TTS_SITES.putAll(message.ttsSites);
    }
}
