/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.ai.manager.entity;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.entity.MaidAIChatData;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.response.ResponseChat;
import com.github.tartaricacid.touhoulittlemaid.ai.manager.setting.Site;
import com.github.tartaricacid.touhoulittlemaid.ai.service.Service;
import com.github.tartaricacid.touhoulittlemaid.ai.service.chat.openai.ChatClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.chat.openai.request.ChatCompletion;
import com.github.tartaricacid.touhoulittlemaid.ai.service.chat.openai.response.ChatCompletionResponse;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSApiType;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSClient;
import com.github.tartaricacid.touhoulittlemaid.ai.service.tts.TTSRequest;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.AIConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.chatbubble.ChatBubbleManger;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.TTSAudioToClientPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.TTSSystemAudioToClientPackage;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class MaidAIChatManager
extends MaidAIChatData {
    public MaidAIChatManager(EntityMaid maid) {
        super(maid);
    }

    public void chat(String message, String language) {
        if (((Boolean)AIConfig.CHAT_ENABLED.get()).booleanValue()) {
            @Nullable Site site = this.getChatSite();
            if (site == null || StringUtils.isBlank((CharSequence)site.getApiKey())) {
                ChatBubbleManger.addInnerChatText(this.maid, "ai.touhou_little_maid.chat.api_key.empty");
            } else {
                ChatClient chatClient = Service.getChatClient(site);
                ChatCompletion chatCompletion = Service.getChatCompletion(this, language);
                if (chatCompletion != null) {
                    chatCompletion.userChat(message);
                    chatClient.chat(chatCompletion).handle(this::onShowChatSync, this::onChatFailSync);
                    this.addUserHistory(message);
                } else {
                    ChatBubbleManger.addInnerChatText(this.maid, "ai.touhou_little_maid.chat.no_setting");
                }
            }
        } else {
            ChatBubbleManger.addInnerChatText(this.maid, "ai.touhou_little_maid.chat.disable");
        }
    }

    private void tts(Site site, String chatText, String ttsText) {
        if (TTSApiType.SYSTEM.getName().equals(site.getApiType())) {
            this.onPlaySoundLocal(chatText, ttsText);
        } else {
            TTSClient<?> ttsClient = Service.getTtsClient(site);
            String ttsLang = "en";
            String[] split = this.getTtsLanguage().split("_");
            if (split.length >= 2) {
                ttsLang = split[0];
            }
            TTSRequest ttsRequest = Service.getTtsRequest(site, ttsText, ttsLang, this.getTtsModel());
            ttsClient.request(ttsRequest).handle(data -> this.onPlaySoundSync(chatText, (byte[])data), throwable -> this.onTtsFailSync(chatText, (Throwable)throwable));
        }
    }

    private void onShowChatSync(ChatCompletionResponse result) {
        String rawMessage = result.getFirstChoiceMessage();
        try {
            ResponseChat responseChat = (ResponseChat)Service.GSON.fromJson(rawMessage, ResponseChat.class);
            if (responseChat == null) {
                TouhouLittleMaid.LOGGER.error("Error in Response Chat: {}", (Object)rawMessage);
                this.onChatFailSync((class_2561)class_2561.method_43469((String)"ai.touhou_little_maid.chat.format.json_format_error", (Object[])new Object[]{rawMessage}));
                return;
            }
            String chatText = responseChat.getChatText();
            String ttsText = responseChat.getTtsText();
            if (StringUtils.isBlank((CharSequence)chatText) || StringUtils.isBlank((CharSequence)ttsText)) {
                TouhouLittleMaid.LOGGER.error("Error in Response Chat: {}", (Object)rawMessage);
                this.onChatFailSync((class_2561)class_2561.method_43469((String)"ai.touhou_little_maid.chat.format.text_is_empty", (Object[])new Object[]{rawMessage}));
                return;
            }
            this.addAssistantHistory(rawMessage);
            Site site = this.getTtsSite();
            if (((Boolean)AIConfig.TTS_ENABLED.get()).booleanValue() && site != null && StringUtils.isNotBlank((CharSequence)site.getApiKey())) {
                this.tts(site, chatText, ttsText);
            } else {
                ChatBubbleManger.addAiChatTextSync(this.maid, chatText);
            }
        }
        catch (Exception e) {
            TouhouLittleMaid.LOGGER.error(e.getMessage());
        }
    }

    private void onChatFailSync(Throwable throwable) {
        class_1937 class_19372 = this.maid.field_6002;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        MinecraftServer server = serverLevel.method_8503();
        server.method_20493(() -> {
            class_1309 patt0$temp = this.maid.method_35057();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                String cause = throwable.getLocalizedMessage();
                player.method_43496((class_2561)class_2561.method_43471((String)"ai.touhou_little_maid.chat.connect.fail").method_27693(cause).method_27692(class_124.field_1061));
            }
        });
    }

    private void onChatFailSync(class_2561 message) {
        class_1937 class_19372 = this.maid.field_6002;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        MinecraftServer server = serverLevel.method_8503();
        server.method_20493(() -> {
            class_1309 patt0$temp = this.maid.method_35057();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                player.method_43496((class_2561)class_2561.method_43471((String)"ai.touhou_little_maid.chat.connect.fail").method_10852(message).method_27692(class_124.field_1061));
            }
        });
    }

    private void onPlaySoundLocal(String chatText, String ttsText) {
        class_1937 class_19372 = this.maid.field_6002;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        MinecraftServer server = serverLevel.method_8503();
        server.method_20493(() -> {
            class_1309 patt0$temp = this.maid.method_35057();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                ServerPlayNetworking.send((class_3222)player, (class_8710)new TTSSystemAudioToClientPackage(ttsText));
            }
            ChatBubbleManger.addAiChatText(this.maid, chatText);
        });
    }

    private void onPlaySoundSync(String chatText, byte[] data) {
        class_1937 class_19372 = this.maid.field_6002;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        MinecraftServer server = serverLevel.method_8503();
        server.method_20493(() -> {
            NetworkHandler.sendToNearby((class_1297)this.maid, new TTSAudioToClientPackage(this.maid.method_5628(), data));
            ChatBubbleManger.addAiChatText(this.maid, chatText);
        });
    }

    private void onTtsFailSync(String chatText, Throwable throwable) {
        class_1937 class_19372 = this.maid.field_6002;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        MinecraftServer server = serverLevel.method_8503();
        server.method_20493(() -> {
            ChatBubbleManger.addAiChatText(this.maid, chatText);
            class_1309 patt0$temp = this.maid.method_35057();
            if (patt0$temp instanceof class_3222) {
                class_3222 player = (class_3222)patt0$temp;
                String cause = throwable.getLocalizedMessage();
                player.method_43496((class_2561)class_2561.method_43471((String)"ai.touhou_little_maid.tts.connect.fail").method_27693(cause).method_27692(class_124.field_1061));
            }
        });
    }
}

